/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.query.impl;

import java.util.List;
import java.util.function.Function;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.SearchPredicate;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.dsl.predicate.PredicateFinalStep;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactory;
import org.hibernate.search.engine.search.dsl.projection.ProjectionFinalStep;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactory;
import org.hibernate.search.engine.search.dsl.query.SearchQueryOptionsStep;
import org.hibernate.search.engine.search.dsl.query.SearchQueryPredicateStep;
import org.hibernate.search.engine.search.dsl.query.impl.DefaultSearchQueryOptionsStep;
import org.hibernate.search.engine.search.dsl.query.spi.AbstractSearchQueryHitTypeStep;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

public final class DefaultSearchQueryHitTypeStep<R, E, C>
extends AbstractSearchQueryHitTypeStep<SearchQueryOptionsStep<?, E, ?>, R, E, SearchProjectionFactory<R, E>, SearchPredicateFactory, C> {
    private final IndexScope<C> indexScope;
    private final SessionContextImplementor sessionContext;
    private final LoadingContextBuilder<R, E> loadingContextBuilder;

    public DefaultSearchQueryHitTypeStep(IndexScope<C> indexScope, SessionContextImplementor sessionContext, LoadingContextBuilder<R, E> loadingContextBuilder) {
        this.indexScope = indexScope;
        this.sessionContext = sessionContext;
        this.loadingContextBuilder = loadingContextBuilder;
    }

    @Override
    public SearchQueryPredicateStep<?, E, ?> asEntity() {
        SearchQueryBuilder<E, C> builder = this.indexScope.getSearchQueryBuilderFactory().asEntity(this.sessionContext, this.loadingContextBuilder);
        return new DefaultSearchQueryOptionsStep<E, C>(this.indexScope, builder);
    }

    @Override
    public SearchQueryPredicateStep<?, R, ?> asEntityReference() {
        SearchQueryBuilder<R, C> builder = this.indexScope.getSearchQueryBuilderFactory().asReference(this.sessionContext, this.loadingContextBuilder);
        return new DefaultSearchQueryOptionsStep<R, C>(this.indexScope, builder);
    }

    @Override
    public <P> SearchQueryPredicateStep<?, P, ?> asProjection(Function<? super SearchProjectionFactory<R, E>, ? extends ProjectionFinalStep<P>> projectionContributor) {
        SearchProjectionFactory factory = this.createDefaultProjectionFactory();
        SearchProjection<P> projection = projectionContributor.apply(factory).toProjection();
        return this.asProjection(projection);
    }

    @Override
    public <P> SearchQueryPredicateStep<?, P, ?> asProjection(SearchProjection<P> projection) {
        SearchQueryBuilder<P, C> builder = this.indexScope.getSearchQueryBuilderFactory().asProjection(this.sessionContext, this.loadingContextBuilder, projection);
        return new DefaultSearchQueryOptionsStep<P, C>(this.indexScope, builder);
    }

    @Override
    public SearchQueryPredicateStep<?, List<?>, ?> asProjections(SearchProjection<?> ... projections) {
        SearchQueryBuilder<List<R>, C> builder = this.indexScope.getSearchQueryBuilderFactory().asProjections(this.sessionContext, this.loadingContextBuilder, projections);
        return new DefaultSearchQueryOptionsStep<List<R>, C>(this.indexScope, builder);
    }

    @Override
    public SearchQueryOptionsStep<?, E, ?> predicate(Function<? super SearchPredicateFactory, ? extends PredicateFinalStep> predicateContributor) {
        return this.asEntity().predicate(predicateContributor);
    }

    @Override
    public SearchQueryOptionsStep<?, E, ?> predicate(SearchPredicate predicate) {
        return this.asEntity().predicate(predicate);
    }

    @Override
    protected IndexScope<C> getIndexScope() {
        return this.indexScope;
    }

    @Override
    protected SessionContextImplementor getSessionContext() {
        return this.sessionContext;
    }

    @Override
    protected LoadingContextBuilder<R, E> getLoadingContextBuilder() {
        return this.loadingContextBuilder;
    }
}

