/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.dsl.predicate.MatchPredicateFieldMoreStep;
import org.hibernate.search.engine.search.dsl.predicate.MatchPredicateOptionsStep;
import org.hibernate.search.engine.search.dsl.predicate.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class MatchPredicateFieldMoreStepImpl<B>
implements MatchPredicateFieldMoreStep,
AbstractBooleanMultiFieldPredicateCommonState.FieldSetState<B> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final CommonState<B> commonState;
    private final List<String> absoluteFieldPaths;
    private final List<MatchPredicateBuilder<B>> predicateBuilders = new ArrayList<MatchPredicateBuilder<B>>();
    private Float fieldSetBoost;

    MatchPredicateFieldMoreStepImpl(CommonState<B> commonState, List<String> absoluteFieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.absoluteFieldPaths = absoluteFieldPaths;
        SearchPredicateBuilderFactory predicateFactory = commonState.getFactory();
        for (String absoluteFieldPath : absoluteFieldPaths) {
            this.predicateBuilders.add(predicateFactory.match(absoluteFieldPath));
        }
    }

    @Override
    public MatchPredicateFieldMoreStep orFields(String ... absoluteFieldPaths) {
        return new MatchPredicateFieldMoreStepImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths));
    }

    @Override
    public MatchPredicateFieldMoreStep boostedTo(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this;
    }

    @Override
    public MatchPredicateOptionsStep matching(Object value, ValueConvert convert) {
        return this.commonState.matching(value, convert);
    }

    @Override
    public List<String> getAbsoluteFieldPaths() {
        return this.absoluteFieldPaths;
    }

    @Override
    public void contributePredicateBuilders(Consumer<B> collector) {
        for (MatchPredicateBuilder<B> predicateBuilder : this.predicateBuilders) {
            this.commonState.applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.toImplementation());
        }
    }

    static class CommonState<B>
    extends AbstractBooleanMultiFieldPredicateCommonState<CommonState<B>, B, MatchPredicateFieldMoreStepImpl<B>>
    implements MatchPredicateOptionsStep {
        CommonState(SearchPredicateBuilderFactory<?, B> builderFactory) {
            super(builderFactory);
        }

        MatchPredicateOptionsStep matching(Object value, ValueConvert convert) {
            if (value == null) {
                throw log.matchPredicateCannotMatchNullValue(this.getEventContext());
            }
            for (MatchPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                for (MatchPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders) {
                    predicateBuilder.value(value, convert);
                }
            }
            return this;
        }

        @Override
        public MatchPredicateOptionsStep fuzzy(int maxEditDistance, int exactPrefixLength) {
            if (maxEditDistance < 0 || 2 < maxEditDistance) {
                throw log.invalidFuzzyMaximumEditDistance(maxEditDistance);
            }
            if (exactPrefixLength < 0) {
                throw log.invalidExactPrefixLength(exactPrefixLength);
            }
            for (MatchPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                for (MatchPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders) {
                    predicateBuilder.fuzzy(maxEditDistance, exactPrefixLength);
                }
            }
            return this;
        }

        @Override
        public MatchPredicateOptionsStep analyzer(String analyzerName) {
            for (MatchPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                for (MatchPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders) {
                    predicateBuilder.analyzer(analyzerName);
                }
            }
            return this;
        }

        @Override
        public MatchPredicateOptionsStep skipAnalysis() {
            for (MatchPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                for (MatchPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders) {
                    predicateBuilder.skipAnalysis();
                }
            }
            return this;
        }

        @Override
        protected CommonState<B> thisAsS() {
            return this;
        }
    }
}

