/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.predicate.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.hibernate.search.engine.search.SearchPredicate;
import org.hibernate.search.engine.search.dsl.predicate.MatchAllPredicateOptionsStep;
import org.hibernate.search.engine.search.dsl.predicate.PredicateFinalStep;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactory;
import org.hibernate.search.engine.search.dsl.predicate.spi.AbstractPredicateFinalStep;
import org.hibernate.search.engine.search.predicate.spi.BooleanPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchAllPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;

class MatchAllPredicateOptionsStepImpl<B>
extends AbstractPredicateFinalStep<B>
implements MatchAllPredicateOptionsStep {
    private final SearchPredicateFactory factory;
    private final MatchAllPredicateBuilder<B> matchAllBuilder;
    private MatchAllExceptState exceptState;

    MatchAllPredicateOptionsStepImpl(SearchPredicateBuilderFactory<?, B> builderFactory, SearchPredicateFactory factory) {
        super(builderFactory);
        this.factory = factory;
        this.matchAllBuilder = builderFactory.matchAll();
    }

    @Override
    public MatchAllPredicateOptionsStep boostedTo(float boost) {
        this.matchAllBuilder.boost(boost);
        return this;
    }

    @Override
    public MatchAllPredicateOptionsStep except(SearchPredicate searchPredicate) {
        this.getExceptState().addClause(searchPredicate);
        return this;
    }

    @Override
    public MatchAllPredicateOptionsStep except(Function<? super SearchPredicateFactory, ? extends PredicateFinalStep> clauseContributor) {
        this.getExceptState().addClause(clauseContributor);
        return this;
    }

    @Override
    protected B toImplementation() {
        if (this.exceptState != null) {
            return this.exceptState.toImplementation(this.matchAllBuilder.toImplementation());
        }
        return this.matchAllBuilder.toImplementation();
    }

    private MatchAllExceptState getExceptState() {
        if (this.exceptState == null) {
            this.exceptState = new MatchAllExceptState();
        }
        return this.exceptState;
    }

    private class MatchAllExceptState {
        private final BooleanPredicateBuilder<B> booleanBuilder;
        private final List<B> clauseBuilders = new ArrayList();

        MatchAllExceptState() {
            this.booleanBuilder = MatchAllPredicateOptionsStepImpl.this.builderFactory.bool();
        }

        void addClause(Function<? super SearchPredicateFactory, ? extends PredicateFinalStep> clauseContributor) {
            this.addClause(clauseContributor.apply(MatchAllPredicateOptionsStepImpl.this.factory).toPredicate());
        }

        void addClause(SearchPredicate predicate) {
            this.clauseBuilders.add(MatchAllPredicateOptionsStepImpl.this.builderFactory.toImplementation(predicate));
        }

        B toImplementation(B matchAllBuilder) {
            this.booleanBuilder.must(matchAllBuilder);
            for (Object builder : this.clauseBuilders) {
                this.booleanBuilder.mustNot(builder);
            }
            return this.booleanBuilder.toImplementation();
        }
    }
}

