/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.impl;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaNestingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexSchemaContributionListener;

class NotifyingNestingContext
implements IndexSchemaNestingContext {
    private final IndexSchemaNestingContext delegate;
    private final IndexSchemaContributionListener listener;

    NotifyingNestingContext(IndexSchemaNestingContext delegate, IndexSchemaContributionListener listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    @Override
    public <T> T nest(String relativeFieldName, Function<String, T> nestedElementFactoryIfIncluded, Function<String, T> nestedElementFactoryIfExcluded) {
        return (T)this.delegate.nest(relativeFieldName, (String prefixedName) -> {
            this.listener.onSchemaContributed();
            return nestedElementFactoryIfIncluded.apply((String)prefixedName);
        }, nestedElementFactoryIfExcluded);
    }

    @Override
    public <T> T nest(String relativeFieldName, BiFunction<String, IndexSchemaNestingContext, T> nestedElementFactoryIfIncluded, BiFunction<String, IndexSchemaNestingContext, T> nestedElementFactoryIfExcluded) {
        return (T)this.delegate.nest(relativeFieldName, (String prefixedName, IndexSchemaNestingContext nestingContext) -> {
            this.listener.onSchemaContributed();
            return nestedElementFactoryIfIncluded.apply((String)prefixedName, new NotifyingNestingContext((IndexSchemaNestingContext)nestingContext, this.listener));
        }, nestedElementFactoryIfExcluded);
    }
}

