/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.hibernate.search.engine.backend.Backend;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.mapper.mapping.spi.MappingImplementor;
import org.hibernate.search.engine.mapper.mapping.spi.MappingKey;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class SearchIntegrationImpl
implements SearchIntegration {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanProvider beanProvider;
    private final Map<MappingKey<?, ?>, MappingImplementor<?>> mappings;
    private final Map<String, BackendImplementor<?>> backends;
    private final Map<String, IndexManagerImplementor<?>> indexManagers;

    SearchIntegrationImpl(BeanProvider beanProvider, Map<MappingKey<?, ?>, MappingImplementor<?>> mappings, Map<String, BackendImplementor<?>> backends, Map<String, IndexManagerImplementor<?>> indexManagers) {
        this.beanProvider = beanProvider;
        this.mappings = mappings;
        this.backends = backends;
        this.indexManagers = indexManagers;
    }

    @Override
    public <M> M getMapping(MappingKey<?, M> mappingKey) {
        MappingImplementor<?> mappingImplementor = this.mappings.get(mappingKey);
        if (mappingImplementor == null) {
            throw log.noMappingRegistered(mappingKey);
        }
        return (M)mappingImplementor.toConcreteType();
    }

    @Override
    public Backend getBackend(String backendName) {
        BackendImplementor<?> backend = this.backends.get(backendName);
        if (backend == null) {
            throw log.noBackendRegistered(backendName);
        }
        return backend.toAPI();
    }

    @Override
    public IndexManager getIndexManager(String indexManagerName) {
        IndexManagerImplementor<?> indexManager = this.indexManagers.get(indexManagerName);
        if (indexManager == null) {
            throw log.noIndexManagerRegistered(indexManagerName);
        }
        return indexManager.toAPI();
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.pushAll(MappingImplementor::close, this.mappings.values());
            closer.pushAll(IndexManagerImplementor::close, this.indexManagers.values());
            closer.pushAll(BackendImplementor::close, this.backends.values());
            closer.pushAll(BeanProvider::close, (Object[])new BeanProvider[]{this.beanProvider});
        }
    }
}

