/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.common.impl.IndexManagerBuildingStateHolder;
import org.hibernate.search.engine.common.impl.MappingBuildContextImpl;
import org.hibernate.search.engine.common.impl.RootBuildContext;
import org.hibernate.search.engine.common.impl.SearchIntegrationPartialBuildStateImpl;
import org.hibernate.search.engine.common.spi.SearchIntegrationBuilder;
import org.hibernate.search.engine.common.spi.SearchIntegrationPartialBuildState;
import org.hibernate.search.engine.environment.bean.impl.ConfiguredBeanResolver;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.engine.environment.bean.spi.ReflectionBeanProvider;
import org.hibernate.search.engine.environment.classpath.spi.AggregatedClassLoader;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.DefaultClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.DefaultResourceResolver;
import org.hibernate.search.engine.environment.classpath.spi.DefaultServiceResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;
import org.hibernate.search.engine.environment.classpath.spi.ServiceResolver;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.mapper.mapping.building.spi.Mapper;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingAbortedException;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingInitiator;
import org.hibernate.search.engine.mapper.mapping.building.spi.TypeMetadataContributorProvider;
import org.hibernate.search.engine.mapper.mapping.building.spi.TypeMetadataDiscoverer;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.spi.MappingKey;
import org.hibernate.search.engine.mapper.mapping.spi.MappingPartialBuildState;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.reporting.impl.RootFailureCollector;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class SearchIntegrationBuilderImpl
implements SearchIntegrationBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final int FAILURE_LIMIT = 100;
    private final ConfigurationPropertySource mainPropertySource;
    private final Map<MappingKey<?, ?>, MappingInitiator<?, ?>> mappingInitiators = new LinkedHashMap();
    private ClassResolver classResolver;
    private ResourceResolver resourceResolver;
    private ServiceResolver serviceResolver;
    private BeanProvider beanProvider;
    private boolean frozen = false;

    public SearchIntegrationBuilderImpl(ConfigurationPropertySource mainPropertySource) {
        this.mainPropertySource = mainPropertySource;
    }

    @Override
    public SearchIntegrationBuilder setClassResolver(ClassResolver classResolver) {
        this.classResolver = classResolver;
        return this;
    }

    @Override
    public SearchIntegrationBuilder setResourceResolver(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        return this;
    }

    @Override
    public SearchIntegrationBuilder setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
        return this;
    }

    @Override
    public SearchIntegrationBuilder setBeanProvider(BeanProvider beanProvider) {
        this.beanProvider = beanProvider;
        return this;
    }

    @Override
    public <PBM extends MappingPartialBuildState> SearchIntegrationBuilder addMappingInitiator(MappingKey<PBM, ?> mappingKey, MappingInitiator<?, PBM> initiator) {
        if (this.frozen) {
            throw new AssertionFailure("Attempt to add a mapping initiator after Hibernate Search has started to build the mappings. There is a bug in the Hibernate Search integration.");
        }
        MappingInitiator<?, PBM> existing = this.mappingInitiators.putIfAbsent(mappingKey, initiator);
        if (existing != null) {
            throw new AssertionFailure("Mapping key '" + mappingKey + "' has multiple initiators: '" + existing + "', '" + initiator + "'. There is a bug in the mapper, please report it.");
        }
        return this;
    }

    @Override
    public SearchIntegrationPartialBuildState prepareBuild() {
        IndexManagerBuildingStateHolder indexManagerBuildingStateHolder = null;
        ArrayList<MappingBuildingState> mappingBuildingStates = new ArrayList<MappingBuildingState>();
        HashMap partiallyBuiltMappings = new HashMap();
        RootFailureCollector failureCollector = new RootFailureCollector(100);
        boolean checkingRootFailures = false;
        try {
            this.frozen = true;
            AggregatedClassLoader aggregatedClassLoader = null;
            if (this.classResolver == null) {
                aggregatedClassLoader = AggregatedClassLoader.createDefault();
                this.classResolver = DefaultClassResolver.create(aggregatedClassLoader);
            }
            if (this.resourceResolver == null) {
                if (aggregatedClassLoader == null) {
                    aggregatedClassLoader = AggregatedClassLoader.createDefault();
                }
                this.resourceResolver = DefaultResourceResolver.create(aggregatedClassLoader);
            }
            if (this.serviceResolver == null) {
                if (aggregatedClassLoader == null) {
                    aggregatedClassLoader = AggregatedClassLoader.createDefault();
                }
                this.serviceResolver = DefaultServiceResolver.create(aggregatedClassLoader);
            }
            if (this.beanProvider == null) {
                this.beanProvider = ReflectionBeanProvider.create(this.classResolver);
            }
            ConfigurationPropertySource propertySource = this.mainPropertySource;
            ConfiguredBeanResolver beanResolver = new ConfiguredBeanResolver(this.serviceResolver, this.beanProvider, propertySource);
            RootBuildContext rootBuildContext = new RootBuildContext(this.classResolver, this.resourceResolver, beanResolver, failureCollector);
            indexManagerBuildingStateHolder = new IndexManagerBuildingStateHolder(beanResolver, propertySource, rootBuildContext);
            for (Map.Entry<MappingKey<?, ?>, MappingInitiator<?, ?>> entry : this.mappingInitiators.entrySet()) {
                MappingBuildingState mappingBuildingState = new MappingBuildingState(rootBuildContext, entry.getKey(), entry.getValue());
                mappingBuildingStates.add(mappingBuildingState);
                mappingBuildingState.collect();
            }
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            LinkedHashSet<String> backendNames = new LinkedHashSet<String>();
            for (MappingBuildingState mappingBuildingState : mappingBuildingStates) {
                mappingBuildingState.contributeBackendNames(backendNames);
            }
            indexManagerBuildingStateHolder.createBackends(backendNames);
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            for (MappingBuildingState mappingBuildingState : mappingBuildingStates) {
                mappingBuildingState.createMapper(indexManagerBuildingStateHolder);
            }
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            for (MappingBuildingState mappingBuildingState : mappingBuildingStates) {
                mappingBuildingState.partiallyBuildAndAddTo(partiallyBuiltMappings);
            }
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            return new SearchIntegrationPartialBuildStateImpl(this.beanProvider, beanResolver, partiallyBuiltMappings, indexManagerBuildingStateHolder.getBackendPartialBuildStates(), indexManagerBuildingStateHolder.getIndexManagersByName());
        }
        catch (RuntimeException e) {
            Throwable rethrownException;
            if (checkingRootFailures) {
                rethrownException = e;
            } else {
                try {
                    failureCollector.checkNoFailure();
                    rethrownException = e;
                }
                catch (SearchException e2) {
                    rethrownException = e2;
                    rethrownException.addSuppressed(e);
                }
            }
            SuppressingCloser closer = new SuppressingCloser(rethrownException);
            closer.pushAll(MappingPartialBuildState::closeOnFailure, partiallyBuiltMappings.values());
            closer.pushAll(MappingBuildingState::closeOnFailure, mappingBuildingStates);
            closer.pushAll(holder -> holder.closeOnFailure(closer), (Object[])new IndexManagerBuildingStateHolder[]{indexManagerBuildingStateHolder});
            closer.pushAll(BeanProvider::close, (Object[])new BeanProvider[]{this.beanProvider});
            throw rethrownException;
        }
    }

    private static class TypeMappingContribution<C> {
        private final MappableTypeModel typeModel;
        private String indexName;
        private String backendName;
        private final List<C> contributors = new ArrayList<C>();

        TypeMappingContribution(MappableTypeModel typeModel) {
            this.typeModel = typeModel;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String getBackendName() {
            return this.backendName;
        }

        public void mapToIndex(String backendName, String indexName) {
            if (this.indexName != null) {
                throw log.multipleIndexMapping(this.typeModel, this.indexName, indexName);
            }
            this.backendName = backendName;
            this.indexName = indexName;
        }

        public void collectContributor(C contributor) {
            this.contributors.add(contributor);
        }

        public Stream<C> getContributors() {
            return this.contributors.stream();
        }
    }

    private static class MappingBuildingState<C, PBM extends MappingPartialBuildState> {
        private final MappingBuildContext buildContext;
        private final MappingKey<PBM, ?> mappingKey;
        private final MappingInitiator<C, PBM> mappingInitiator;
        private final Map<MappableTypeModel, TypeMappingContribution<C>> contributionByType = new LinkedHashMap<MappableTypeModel, TypeMappingContribution<C>>();
        private final List<TypeMetadataDiscoverer<C>> metadataDiscoverers = new ArrayList<TypeMetadataDiscoverer<C>>();
        private boolean multiTenancyEnabled;
        private final Set<MappableTypeModel> typesSubmittedToDiscoverers = new HashSet<MappableTypeModel>();
        private Mapper<PBM> mapper;

        MappingBuildingState(RootBuildContext rootBuildContext, MappingKey<PBM, ?> mappingKey, MappingInitiator<C, PBM> mappingInitiator) {
            this.mappingKey = mappingKey;
            this.buildContext = new MappingBuildContextImpl(rootBuildContext, mappingKey);
            this.mappingInitiator = mappingInitiator;
        }

        void collect() {
            this.mappingInitiator.configure(this.buildContext, new MappingConfigurationCollectorImpl());
        }

        void contributeBackendNames(Set<String> backendNames) {
            for (TypeMappingContribution<C> contribution : this.contributionByType.values()) {
                if (contribution.getIndexName() == null) continue;
                String backendName = contribution.getBackendName();
                backendNames.add(backendName);
            }
        }

        void createMapper(IndexManagerBuildingStateHolder indexManagerBuildingStateHolder) {
            TypeMetadataContributorProviderImpl contributorProvider = new TypeMetadataContributorProviderImpl();
            this.mapper = this.mappingInitiator.createMapper(this.buildContext, contributorProvider);
            LinkedHashSet<MappableTypeModel> potentiallyMappedToIndexTypes = new LinkedHashSet<MappableTypeModel>(this.contributionByType.keySet());
            for (MappableTypeModel typeModel : potentiallyMappedToIndexTypes) {
                IndexManagerBuildingStateHolder.IndexManagerInitialBuildState<?> indexManagerBuildingState;
                TypeMappingContribution<C> contribution = this.contributionByType.get(typeModel);
                String indexName = contribution.getIndexName();
                if (indexName == null) continue;
                String backendName = contribution.getBackendName();
                try {
                    indexManagerBuildingState = indexManagerBuildingStateHolder.getBackend(backendName).getIndexManagerBuildingState(indexName, this.multiTenancyEnabled);
                }
                catch (RuntimeException e) {
                    this.buildContext.getFailureCollector().withContext(EventContexts.fromType(typeModel)).withContext(EventContexts.fromIndexName(indexName)).add(e);
                    continue;
                }
                try {
                    this.mapper.addIndexed(typeModel, indexManagerBuildingState);
                }
                catch (RuntimeException e) {
                    this.buildContext.getFailureCollector().withContext(EventContexts.fromType(typeModel)).add(e);
                }
            }
        }

        void partiallyBuildAndAddTo(Map<MappingKey<?, ?>, MappingPartialBuildState> mappings) {
            try {
                PBM partiallyBuiltMapping = this.mapper.prepareBuild();
                mappings.put(this.mappingKey, (MappingPartialBuildState)partiallyBuiltMapping);
            }
            catch (MappingAbortedException e) {
                Throwable[] suppressed;
                ContextualFailureCollector failureCollector = this.buildContext.getFailureCollector();
                if (!failureCollector.hasFailure()) {
                    throw new AssertionFailure("Caught " + MappingAbortedException.class.getSimpleName() + ", but the mapper did not collect any failure. There is a bug in the mapper, please report it.", (Throwable)e);
                }
                Throwable cause = e.getCause();
                if (cause != null) {
                    failureCollector.add(cause);
                }
                for (Throwable throwable : suppressed = e.getSuppressed()) {
                    failureCollector.add(throwable);
                }
            }
        }

        private TypeMappingContribution<C> getOrCreateContribution(MappableTypeModel typeModel) {
            TypeMappingContribution<C> contribution = this.contributionByType.get(typeModel);
            if (contribution == null) {
                contribution = new TypeMappingContribution(typeModel);
                this.contributionByType.put(typeModel, contribution);
            }
            return contribution;
        }

        private TypeMappingContribution<C> getContributionIncludingAutomaticallyDiscovered(MappableTypeModel typeModel) {
            if (!this.typesSubmittedToDiscoverers.contains(typeModel)) {
                for (TypeMetadataDiscoverer<C> metadataDiscoverer : this.metadataDiscoverers) {
                    Optional<C> discoveredContributor = metadataDiscoverer.discover(typeModel);
                    if (!discoveredContributor.isPresent()) continue;
                    this.getOrCreateContribution(typeModel).collectContributor(discoveredContributor.get());
                }
                this.typesSubmittedToDiscoverers.add(typeModel);
            }
            return this.contributionByType.get(typeModel);
        }

        public void closeOnFailure() {
            if (this.mapper != null) {
                this.mapper.closeOnFailure();
            }
        }

        private class TypeMetadataContributorProviderImpl
        implements TypeMetadataContributorProvider<C> {
            private TypeMetadataContributorProviderImpl() {
            }

            @Override
            public Set<C> get(MappableTypeModel typeModel) {
                return typeModel.getDescendingSuperTypes().map(x$0 -> MappingBuildingState.this.getContributionIncludingAutomaticallyDiscovered(x$0)).filter(Objects::nonNull).flatMap(TypeMappingContribution::getContributors).collect(Collectors.toCollection(LinkedHashSet::new));
            }

            @Override
            public Set<? extends MappableTypeModel> getTypesContributedTo() {
                return Collections.unmodifiableSet(new LinkedHashSet(MappingBuildingState.this.contributionByType.keySet()));
            }
        }

        private class MappingConfigurationCollectorImpl
        implements MappingConfigurationCollector<C> {
            private MappingConfigurationCollectorImpl() {
            }

            @Override
            public void mapToIndex(MappableTypeModel typeModel, String backendName, String indexName) {
                if (typeModel.isAbstract()) {
                    throw log.cannotMapAbstractTypeToIndex(typeModel, indexName);
                }
                MappingBuildingState.this.getOrCreateContribution(typeModel).mapToIndex(backendName, indexName);
            }

            @Override
            public void collectContributor(MappableTypeModel typeModel, C contributor) {
                MappingBuildingState.this.getOrCreateContribution(typeModel).collectContributor(contributor);
            }

            @Override
            public void collectDiscoverer(TypeMetadataDiscoverer<C> metadataDiscoverer) {
                MappingBuildingState.this.metadataDiscoverers.add(metadataDiscoverer);
            }

            @Override
            public void enableMultiTenancy() {
                MappingBuildingState.this.multiTenancyEnabled = true;
            }
        }
    }
}

