/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexDocumentWorkExecutor;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkExecutor;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkPlan;
import org.hibernate.search.engine.common.impl.MappedIndexScopeBuilderImpl;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexManager;
import org.hibernate.search.engine.mapper.scope.spi.MappedIndexScopeBuilder;
import org.hibernate.search.engine.mapper.session.context.spi.DetachedSessionContextImplementor;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;

class MappedIndexManagerImpl<D extends DocumentElement>
implements MappedIndexManager<D> {
    private final IndexManagerImplementor<D> implementor;

    MappedIndexManagerImpl(IndexManagerImplementor<D> implementor) {
        this.implementor = implementor;
    }

    @Override
    public IndexManager toAPI() {
        return this.implementor.toAPI();
    }

    @Override
    public IndexWorkPlan<D> createWorkPlan(SessionContextImplementor sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.implementor.createWorkPlan(sessionContext, commitStrategy, refreshStrategy);
    }

    @Override
    public IndexDocumentWorkExecutor<D> createDocumentWorkExecutor(SessionContextImplementor sessionContext, DocumentCommitStrategy commitStrategy) {
        return this.implementor.createDocumentWorkExecutor(sessionContext, commitStrategy);
    }

    @Override
    public IndexWorkExecutor createWorkExecutor(DetachedSessionContextImplementor sessionContext) {
        return this.implementor.createWorkExecutor(sessionContext);
    }

    @Override
    public <R, E> MappedIndexScopeBuilder<R, E> createScopeBuilder(MappingContextImplementor mappingContext) {
        return new MappedIndexScopeBuilderImpl(this.implementor, mappingContext);
    }

    @Override
    public void addTo(MappedIndexScopeBuilder<?, ?> builder) {
        ((MappedIndexScopeBuilderImpl)builder).add(this.implementor);
    }
}

