/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.cfg.impl.EngineConfigurationUtils;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.common.impl.IndexManagerStartContextImpl;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.reporting.impl.RootFailureCollector;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;

class IndexManagerPartialBuildState {
    private final String backendName;
    private final String indexName;
    private final IndexManagerImplementor<?> partiallyBuiltIndexManager;

    IndexManagerPartialBuildState(String backendName, String indexName, IndexManagerImplementor<?> partiallyBuiltIndexManager) {
        this.backendName = backendName;
        this.indexName = indexName;
        this.partiallyBuiltIndexManager = partiallyBuiltIndexManager;
    }

    void closeOnFailure() {
        this.partiallyBuiltIndexManager.close();
    }

    IndexManagerImplementor<?> finalizeBuild(RootFailureCollector rootFailureCollector, BeanResolver beanResolver, ConfigurationPropertySource rootPropertySource) {
        ContextualFailureCollector indexFailureCollector = rootFailureCollector.withContext(EventContexts.fromIndexName(this.indexName));
        ConfigurationPropertySource backendPropertySource = EngineConfigurationUtils.getBackend(rootPropertySource, this.backendName);
        ConfigurationPropertySource indexPropertySource = EngineConfigurationUtils.getIndex(backendPropertySource, EngineConfigurationUtils.getIndexDefaults(backendPropertySource), this.indexName);
        IndexManagerStartContextImpl startContext = new IndexManagerStartContextImpl(indexFailureCollector, beanResolver, indexPropertySource);
        try {
            this.partiallyBuiltIndexManager.start(startContext);
        }
        catch (RuntimeException e) {
            indexFailureCollector.add(e);
        }
        return this.partiallyBuiltIndexManager;
    }
}

