/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public interface ElasticsearchSearchProjection<P>
extends SearchProjection<P> {
    public static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public Set<String> indexNames();

    public Extractor<?, P> request(JsonObject var1, ProjectionRequestContext var2);

    public static <P> ElasticsearchSearchProjection<P> from(ElasticsearchSearchIndexScope<?> scope, SearchProjection<P> projection) {
        if (!(projection instanceof ElasticsearchSearchProjection)) {
            throw log.cannotMixElasticsearchSearchQueryWithOtherProjections(projection);
        }
        ElasticsearchSearchProjection casted = (ElasticsearchSearchProjection)projection;
        if (!scope.hibernateSearchIndexNames().equals(casted.indexNames())) {
            throw log.projectionDefinedOnDifferentIndexes(projection, casted.indexNames(), scope.hibernateSearchIndexNames());
        }
        return casted;
    }

    public static interface Extractor<E, P> {
        public E extract(ProjectionHitMapper<?, ?> var1, JsonObject var2, JsonObject var3, ProjectionExtractContext var4);

        public P transform(LoadingResult<?, ?> var1, E var2, ProjectionTransformContext var3);

        public static <Z> Z transformUnsafe(Extractor<?, Z> extractor, LoadingResult<?, ?> loadingResult, Object extractedData, ProjectionTransformContext context) {
            return extractor.transform(loadingResult, extractedData, context);
        }
    }
}

