/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

public class ElasticsearchRootContextProjection<P>
extends AbstractElasticsearchProjection<P> {
    private static final JsonObjectAccessor HIT_SOURCE_ACCESSOR = JsonAccessor.root().property("_source").asObject();
    private final ElasticsearchSearchProjection<P> inner;

    public ElasticsearchRootContextProjection(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchProjection<P> inner) {
        super(scope);
        this.inner = inner;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[inner=" + this.inner + "]";
    }

    @Override
    public ElasticsearchSearchProjection.Extractor<?, P> request(JsonObject requestBody, ProjectionRequestContext context) {
        if (context.absoluteCurrentFieldPath() == null) {
            return this.inner.request(requestBody, context);
        }
        ProjectionRequestContext innerContext = context.root();
        return new RootContextExtractor(this.inner.request(requestBody, innerContext));
    }

    private static class RootContextExtractor<E, P>
    implements ElasticsearchSearchProjection.Extractor<E, P> {
        private final ElasticsearchSearchProjection.Extractor<E, P> inner;

        private RootContextExtractor(ElasticsearchSearchProjection.Extractor<E, P> inner) {
            this.inner = inner;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[inner=" + this.inner + "]";
        }

        @Override
        public E extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject hit, JsonObject source, ProjectionExtractContext context) {
            JsonObject rootSource = HIT_SOURCE_ACCESSOR.get(hit).orElse(null);
            return this.inner.extract(projectionHitMapper, hit, rootSource, context);
        }

        @Override
        public P transform(LoadingResult<?, ?> loadingResult, E extractedData, ProjectionTransformContext context) {
            return this.inner.transform(loadingResult, extractedData, context);
        }
    }
}

