/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.scope.model.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.backend.elasticsearch.common.impl.DocumentIdHelper;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.search.impl.ElasticsearchSearchSyntax;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.search.aggregation.dsl.ElasticsearchSearchAggregationFactory;
import org.hibernate.search.backend.elasticsearch.search.aggregation.dsl.impl.ElasticsearchSearchAggregationFactoryImpl;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregationBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchMultiIndexSearchIndexCompositeNodeContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchMultiIndexSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexCompositeNodeContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexNodeContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.predicate.dsl.ElasticsearchSearchPredicateFactory;
import org.hibernate.search.backend.elasticsearch.search.predicate.dsl.impl.ElasticsearchSearchPredicateFactoryImpl;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.projection.dsl.ElasticsearchSearchProjectionFactory;
import org.hibernate.search.backend.elasticsearch.search.projection.dsl.impl.ElasticsearchSearchProjectionFactoryImpl;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryBuilder;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryIndexScope;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.elasticsearch.search.sort.dsl.ElasticsearchSearchSortFactory;
import org.hibernate.search.backend.elasticsearch.search.sort.dsl.impl.ElasticsearchSearchSortFactoryImpl;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilderFactory;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.scope.spi.AbstractSearchIndexScope;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.search.aggregation.dsl.spi.SearchAggregationDslContext;
import org.hibernate.search.engine.search.aggregation.spi.SearchAggregationIndexScope;
import org.hibernate.search.engine.search.common.spi.SearchIndexCompositeNodeContext;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateIndexScope;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.spi.SearchProjectionDslContext;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionIndexScope;
import org.hibernate.search.engine.search.sort.dsl.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.sort.spi.SearchSortIndexScope;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;

public final class ElasticsearchSearchIndexScopeImpl
extends AbstractSearchIndexScope<ElasticsearchSearchIndexScopeImpl, ElasticsearchIndexModel, ElasticsearchSearchIndexNodeContext, ElasticsearchSearchIndexCompositeNodeContext>
implements ElasticsearchSearchIndexScope<ElasticsearchSearchIndexScopeImpl>,
ElasticsearchSearchQueryIndexScope<ElasticsearchSearchIndexScopeImpl> {
    private final SearchBackendContext backendContext;
    private final Gson userFacingGson;
    private final ElasticsearchSearchSyntax searchSyntax;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final TimingSource timingSource;
    private final Map<String, ElasticsearchSearchIndexContext> mappedTypeNameToIndex;
    private final int maxResultWindow;
    private final ElasticsearchSearchPredicateBuilderFactory predicateBuilderFactory;
    private final ElasticsearchSearchSortBuilderFactory sortBuilderFactory;
    private final ElasticsearchSearchProjectionBuilderFactory projectionBuilderFactory;
    private final ElasticsearchSearchAggregationBuilderFactory aggregationFactory;

    public ElasticsearchSearchIndexScopeImpl(BackendMappingContext mappingContext, SearchBackendContext backendContext, Gson userFacingGson, ElasticsearchSearchSyntax searchSyntax, MultiTenancyStrategy multiTenancyStrategy, TimingSource timingSource, Set<ElasticsearchIndexModel> indexModels) {
        super(mappingContext, indexModels);
        this.backendContext = backendContext;
        this.userFacingGson = userFacingGson;
        this.searchSyntax = searchSyntax;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.timingSource = timingSource;
        this.mappedTypeNameToIndex = new LinkedHashMap<String, ElasticsearchSearchIndexContext>();
        for (ElasticsearchIndexModel model : indexModels) {
            this.mappedTypeNameToIndex.put(model.mappedTypeName(), model);
        }
        int currentMaxResultWindow = Integer.MAX_VALUE;
        for (ElasticsearchIndexModel index : indexModels) {
            if (index.maxResultWindow() >= currentMaxResultWindow) continue;
            currentMaxResultWindow = index.maxResultWindow();
        }
        this.maxResultWindow = currentMaxResultWindow;
        this.predicateBuilderFactory = new ElasticsearchSearchPredicateBuilderFactory(this);
        this.sortBuilderFactory = new ElasticsearchSearchSortBuilderFactory(this);
        this.projectionBuilderFactory = new ElasticsearchSearchProjectionBuilderFactory(backendContext.getSearchProjectionBackendContext(), this);
        this.aggregationFactory = new ElasticsearchSearchAggregationBuilderFactory(this);
    }

    private ElasticsearchSearchIndexScopeImpl(ElasticsearchSearchIndexScopeImpl parentScope, ElasticsearchSearchIndexCompositeNodeContext overriddenRoot) {
        super((AbstractSearchIndexScope)parentScope, (SearchIndexCompositeNodeContext)overriddenRoot);
        this.backendContext = parentScope.backendContext;
        this.userFacingGson = parentScope.userFacingGson;
        this.searchSyntax = parentScope.searchSyntax;
        this.multiTenancyStrategy = parentScope.multiTenancyStrategy;
        this.timingSource = parentScope.timingSource;
        this.mappedTypeNameToIndex = parentScope.mappedTypeNameToIndex;
        this.maxResultWindow = parentScope.maxResultWindow;
        this.predicateBuilderFactory = new ElasticsearchSearchPredicateBuilderFactory(this);
        this.sortBuilderFactory = new ElasticsearchSearchSortBuilderFactory(this);
        this.projectionBuilderFactory = new ElasticsearchSearchProjectionBuilderFactory(this.backendContext.getSearchProjectionBackendContext(), this);
        this.aggregationFactory = new ElasticsearchSearchAggregationBuilderFactory(this);
    }

    protected ElasticsearchSearchIndexScopeImpl self() {
        return this;
    }

    public ElasticsearchSearchIndexScopeImpl withRoot(String objectFieldPath) {
        return new ElasticsearchSearchIndexScopeImpl(this, this.field(objectFieldPath).toComposite());
    }

    @Override
    public ElasticsearchSearchPredicateBuilderFactory predicateBuilders() {
        return this.predicateBuilderFactory;
    }

    @Override
    public ElasticsearchSearchSortBuilderFactory sortBuilders() {
        return this.sortBuilderFactory;
    }

    @Override
    public ElasticsearchSearchProjectionBuilderFactory projectionBuilders() {
        return this.projectionBuilderFactory;
    }

    @Override
    public ElasticsearchSearchAggregationBuilderFactory aggregationBuilders() {
        return this.aggregationFactory;
    }

    @Override
    public <P> ElasticsearchSearchQueryBuilder<P> select(BackendSessionContext sessionContext, SearchLoadingContextBuilder<?, ?, ?> loadingContextBuilder, SearchProjection<P> projection) {
        return this.backendContext.createSearchQueryBuilder(this, sessionContext, loadingContextBuilder, ElasticsearchSearchProjection.from(this, projection));
    }

    @Override
    public ElasticsearchSearchPredicateFactory predicateFactory() {
        return new ElasticsearchSearchPredicateFactoryImpl(SearchPredicateDslContext.root((SearchPredicateIndexScope)this));
    }

    @Override
    public ElasticsearchSearchSortFactory sortFactory() {
        return new ElasticsearchSearchSortFactoryImpl(SearchSortDslContext.root((SearchSortIndexScope)this, ElasticsearchSearchSortFactoryImpl::new, (SearchPredicateFactory)this.predicateFactory()));
    }

    @Override
    public <R, E> ElasticsearchSearchProjectionFactory<R, E> projectionFactory() {
        return new ElasticsearchSearchProjectionFactoryImpl(SearchProjectionDslContext.root((SearchProjectionIndexScope)this));
    }

    @Override
    public ElasticsearchSearchAggregationFactory aggregationFactory() {
        return new ElasticsearchSearchAggregationFactoryImpl(SearchAggregationDslContext.root((SearchAggregationIndexScope)this, (SearchPredicateFactory)this.predicateFactory()));
    }

    @Override
    public ElasticsearchSearchIndexNodeContext field(String fieldPath) {
        return (ElasticsearchSearchIndexNodeContext)super.field(fieldPath);
    }

    @Override
    public Gson userFacingGson() {
        return this.userFacingGson;
    }

    @Override
    public ElasticsearchSearchSyntax searchSyntax() {
        return this.searchSyntax;
    }

    @Override
    public DocumentIdHelper documentIdHelper() {
        return this.multiTenancyStrategy.documentIdHelper();
    }

    @Override
    public JsonObject filterOrNull(String tenantId) {
        return this.multiTenancyStrategy.filterOrNull(tenantId);
    }

    @Override
    public TimeoutManager createTimeoutManager(Long timeout, TimeUnit timeUnit, boolean exceptionOnTimeout) {
        if (timeout != null && timeUnit != null) {
            if (exceptionOnTimeout) {
                return TimeoutManager.hardTimeout((TimingSource)this.timingSource, (long)timeout, (TimeUnit)timeUnit);
            }
            return TimeoutManager.softTimeout((TimingSource)this.timingSource, (long)timeout, (TimeUnit)timeUnit);
        }
        return TimeoutManager.noTimeout((TimingSource)this.timingSource);
    }

    @Override
    public Collection<ElasticsearchSearchIndexContext> indexes() {
        return this.mappedTypeNameToIndex.values();
    }

    @Override
    public Map<String, ElasticsearchSearchIndexContext> mappedTypeNameToIndex() {
        return this.mappedTypeNameToIndex;
    }

    @Override
    public int maxResultWindow() {
        return this.maxResultWindow;
    }

    protected ElasticsearchSearchIndexCompositeNodeContext createMultiIndexSearchRootContext(List<ElasticsearchSearchIndexCompositeNodeContext> rootForEachIndex) {
        return new ElasticsearchMultiIndexSearchIndexCompositeNodeContext(this, null, rootForEachIndex);
    }

    protected ElasticsearchSearchIndexNodeContext createMultiIndexSearchValueFieldContext(String absolutePath, List<ElasticsearchSearchIndexNodeContext> fieldForEachIndex) {
        return new ElasticsearchMultiIndexSearchIndexValueFieldContext(this, absolutePath, fieldForEachIndex);
    }

    protected ElasticsearchSearchIndexNodeContext createMultiIndexSearchObjectFieldContext(String absolutePath, List<ElasticsearchSearchIndexNodeContext> fieldForEachIndex) {
        return new ElasticsearchMultiIndexSearchIndexCompositeNodeContext(this, absolutePath, fieldForEachIndex);
    }
}

