/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.schema.management.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;

final class ElasticsearchSchemaDropper {
    private final ElasticsearchSchemaAccessor schemaAccessor;

    public ElasticsearchSchemaDropper(ElasticsearchSchemaAccessor schemaAccessor) {
        this.schemaAccessor = schemaAccessor;
    }

    public CompletableFuture<?> dropIfExisting(IndexNames indexNames, OperationSubmitter operationSubmitter) {
        return this.schemaAccessor.getCurrentIndexMetadataOrNull(indexNames, operationSubmitter).thenCompose(existingIndexMetadata -> {
            if (existingIndexMetadata == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.schemaAccessor.dropIndexIfExisting(URLEncodedString.fromString(existingIndexMetadata.getPrimaryName()), operationSubmitter);
        });
    }
}

