/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.resources.impl;

import org.hibernate.search.backend.elasticsearch.cfg.spi.ElasticsearchBackendSpiSettings;
import org.hibernate.search.backend.elasticsearch.work.spi.ElasticsearchWorkExecutorProvider;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.common.execution.spi.SimpleScheduledExecutor;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.environment.thread.spi.ThreadProvider;
import org.hibernate.search.util.common.AssertionFailure;

public class BackendThreads {
    private static final ConfigurationProperty<BeanReference<? extends ElasticsearchWorkExecutorProvider>> BACKEND_WORK_EXECUTOR_PROVIDER = ConfigurationProperty.forKey((String)"backend_work_executor_provider").asBeanReference(ElasticsearchWorkExecutorProvider.class).withDefault(ElasticsearchBackendSpiSettings.Defaults.BACKEND_WORK_EXECUTOR_PROVIDER).build();
    private final String prefix;
    private ThreadPoolProvider threadPoolProvider;
    private SimpleScheduledExecutor workExecutor;

    public BackendThreads(String prefix) {
        this.prefix = prefix;
    }

    public void onStart(final ConfigurationPropertySource propertySource, BeanResolver beanResolver, final ThreadPoolProvider threadPoolProvider) {
        if (this.workExecutor != null) {
            return;
        }
        this.threadPoolProvider = threadPoolProvider;
        try (BeanHolder provider = (BeanHolder)BACKEND_WORK_EXECUTOR_PROVIDER.getAndTransform(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0));){
            this.workExecutor = ((ElasticsearchWorkExecutorProvider)provider.get()).workExecutor(new ElasticsearchWorkExecutorProvider.Context(){

                @Override
                public ThreadPoolProvider threadPoolProvider() {
                    return threadPoolProvider;
                }

                @Override
                public ConfigurationPropertySource propertySource() {
                    return propertySource;
                }

                @Override
                public String recommendedThreadNamePrefix() {
                    return BackendThreads.this.prefix + " - Worker thread";
                }
            });
        }
    }

    public void onStop() {
        if (this.workExecutor != null) {
            this.workExecutor.shutdownNow();
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ThreadProvider getThreadProvider() {
        this.checkStarted();
        return this.threadPoolProvider.threadProvider();
    }

    public SimpleScheduledExecutor getWorkExecutor() {
        this.checkStarted();
        return this.workExecutor;
    }

    private void checkStarted() {
        if (this.workExecutor == null) {
            throw new AssertionFailure("Attempt to retrieve the executor or related information before the backend was started.");
        }
    }
}

