/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.ScrollWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractNonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.engine.common.timing.spi.Deadline;

public class ScrollWork<R>
extends AbstractNonBulkableWork<R> {
    private final ElasticsearchSearchResultExtractor<R> resultExtractor;
    private final Deadline deadline;
    private final boolean failOnDeadline;

    protected ScrollWork(Builder<R> builder) {
        super(builder);
        this.resultExtractor = ((Builder)builder).resultExtractor;
        this.deadline = ((Builder)builder).deadline;
        this.failOnDeadline = ((Builder)builder).failOnDeadline;
    }

    @Override
    protected R generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        JsonObject body = response.body();
        return this.resultExtractor.extract(body, this.failOnDeadline ? this.deadline : null);
    }

    public static class Builder<R>
    extends AbstractNonBulkableWork.AbstractBuilder<Builder<R>>
    implements ScrollWorkBuilder<R> {
        private final String scrollId;
        private final String scrollTimeout;
        private final ElasticsearchSearchResultExtractor<R> resultExtractor;
        private Deadline deadline;
        private boolean failOnDeadline;

        public Builder(String scrollId, String scrollTimeout, ElasticsearchSearchResultExtractor<R> resultExtractor) {
            super(DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.scrollId = scrollId;
            this.scrollTimeout = scrollTimeout;
            this.resultExtractor = resultExtractor;
        }

        @Override
        public Builder<R> deadline(Deadline deadline, boolean failOnDeadline) {
            this.deadline = deadline;
            this.failOnDeadline = failOnDeadline;
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            JsonObject body = new JsonObject();
            body.addProperty("scroll_id", this.scrollId);
            body.addProperty("scroll", this.scrollTimeout);
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.post().pathComponent(Paths._SEARCH).pathComponent(Paths.SCROLL).body(body);
            return builder.build();
        }

        @Override
        public ScrollWork<R> build() {
            return new ScrollWork(this);
        }
    }
}

