/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClientUtils;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class DefaultElasticsearchRequestSuccessAssessor
implements ElasticsearchRequestSuccessAssessor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<Integer> BULK_ITEM_STATUS_CODE = JsonAccessor.root().property("status").asInteger();
    private static final JsonAccessor<String> ERROR_TYPE = JsonAccessor.root().property("error").property("type").asString();
    private static final int TIME_OUT_HTTP_STATUS_CODE = 408;
    public static final DefaultElasticsearchRequestSuccessAssessor INSTANCE = DefaultElasticsearchRequestSuccessAssessor.builder().build();
    private final Set<Integer> ignoredErrorStatuses;
    private final Set<String> ignoredErrorTypes;

    public static Builder builder() {
        return new Builder();
    }

    private DefaultElasticsearchRequestSuccessAssessor(Builder builder) {
        this.ignoredErrorStatuses = Collections.unmodifiableSet(new HashSet(builder.ignoredErrorStatuses));
        this.ignoredErrorTypes = Collections.unmodifiableSet(new HashSet(builder.ignoredErrorTypes));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "ignoredErrorStatuses=" + this.ignoredErrorStatuses + ", ignoredErrorTypes=" + this.ignoredErrorTypes + "]";
    }

    @Override
    public void checkSuccess(ElasticsearchResponse response) throws SearchException {
        JsonObject responseBody = response.body();
        Optional<Integer> statusCode = Optional.of(response.statusCode());
        this.checkSuccess(statusCode, responseBody);
    }

    @Override
    public void checkSuccess(JsonObject bulkResponseItem) {
        JsonObject responseBody = bulkResponseItem == null ? null : ((JsonElement)((Map.Entry)bulkResponseItem.entrySet().iterator().next()).getValue()).getAsJsonObject();
        Optional<Integer> statusCode = BULK_ITEM_STATUS_CODE.get(responseBody);
        this.checkSuccess(statusCode, responseBody);
    }

    private void checkSuccess(Optional<Integer> statusCode, JsonObject responseBody) {
        if (!this.isSuccess(statusCode, responseBody)) {
            if (statusCode.filter(Predicate.isEqual(408)).isPresent()) {
                throw log.elasticsearchStatus408RequestTimeout();
            }
            throw log.elasticsearchResponseIndicatesFailure();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSuccess(Optional<Integer> statusCode, JsonObject responseBody) {
        if (statusCode.map(c -> ElasticsearchClientUtils.isSuccessCode(c) || this.ignoredErrorStatuses.contains(c)).orElse(false) != false) return true;
        if (ERROR_TYPE.get(responseBody).map(this.ignoredErrorTypes::contains).orElse(false) == false) return false;
        return true;
    }

    public static class Builder {
        private final Set<Integer> ignoredErrorStatuses = new HashSet<Integer>();
        private final Set<String> ignoredErrorTypes = new HashSet<String>();

        public Builder ignoreErrorStatuses(int ... ignoredErrorStatuses) {
            for (int ignoredErrorStatus : ignoredErrorStatuses) {
                this.ignoredErrorStatuses.add(ignoredErrorStatus);
            }
            return this;
        }

        public Builder ignoreErrorTypes(String ... ignoredErrorTypes) {
            Collections.addAll(this.ignoredErrorTypes, ignoredErrorTypes);
            return this;
        }

        public DefaultElasticsearchRequestSuccessAssessor build() {
            return new DefaultElasticsearchRequestSuccessAssessor(this);
        }
    }
}

