/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationTypeKeys;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchRangeAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchTermsAggregation;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchExistsPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchRangePredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateTypeKeys;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchFieldProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionTypeKeys;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.SortTypeKeys;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchSimpleStandardFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.format.impl.ElasticsearchDefaultFieldFormatProvider;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchStandardMatchPredicate;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSort;

abstract class AbstractElasticsearchTemporalIndexFieldTypeOptionsStep<S extends AbstractElasticsearchTemporalIndexFieldTypeOptionsStep<?, F>, F extends TemporalAccessor>
extends AbstractElasticsearchSimpleStandardFieldTypeOptionsStep<S, F> {
    AbstractElasticsearchTemporalIndexFieldTypeOptionsStep(ElasticsearchIndexFieldTypeBuildContext buildContext, Class<F> fieldType) {
        super(buildContext, fieldType, "date");
    }

    @Override
    protected final void complete() {
        ElasticsearchDefaultFieldFormatProvider defaultFieldFormatProvider = this.buildContext.getDefaultFieldFormatProvider();
        this.builder.mapping().setFormat(defaultFieldFormatProvider.getDefaultMappingFormat(this.builder.valueType()));
        DateTimeFormatter formatter = defaultFieldFormatProvider.getDefaultDateTimeFormatter(this.builder.valueType());
        ElasticsearchFieldCodec<F> codec = this.createCodec(formatter);
        this.builder.codec(codec);
        if (this.resolvedSearchable) {
            this.builder.searchable(true);
            this.builder.queryElementFactory(PredicateTypeKeys.MATCH, new ElasticsearchStandardMatchPredicate.Factory<F>(codec));
            this.builder.queryElementFactory(PredicateTypeKeys.RANGE, new ElasticsearchRangePredicate.Factory<F>(codec));
            this.builder.queryElementFactory(PredicateTypeKeys.EXISTS, new ElasticsearchExistsPredicate.Factory());
        }
        if (this.resolvedSortable) {
            this.builder.sortable(true);
            this.builder.queryElementFactory(SortTypeKeys.FIELD, new ElasticsearchStandardFieldSort.TemporalFieldFactory<F>(codec));
        }
        if (this.resolvedProjectable) {
            this.builder.projectable(true);
            this.builder.queryElementFactory(ProjectionTypeKeys.FIELD, new ElasticsearchFieldProjection.Factory<F>(codec));
        }
        if (this.resolvedAggregable) {
            this.builder.aggregable(true);
            this.builder.queryElementFactory(AggregationTypeKeys.TERMS, new ElasticsearchTermsAggregation.Factory<F>(codec));
            this.builder.queryElementFactory(AggregationTypeKeys.RANGE, new ElasticsearchRangeAggregation.Factory<F>(codec));
        }
    }

    protected abstract ElasticsearchFieldCodec<F> createCodec(DateTimeFormatter var1);
}

