/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.sort.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchIndexesContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchCompositeSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchIndexOrderSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchScoreSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchUserProvidedJsonSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.SortTypeKeys;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.spi.CompositeSortBuilder;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.search.sort.spi.FieldSortBuilder;
import org.hibernate.search.engine.search.sort.spi.ScoreSortBuilder;

public class ElasticsearchSearchSortBuilderFactoryImpl
implements ElasticsearchSearchSortBuilderFactory {
    private final ElasticsearchSearchContext searchContext;
    private final ElasticsearchSearchIndexesContext indexes;

    public ElasticsearchSearchSortBuilderFactoryImpl(ElasticsearchSearchContext searchContext) {
        this.searchContext = searchContext;
        this.indexes = searchContext.indexes();
    }

    public void contribute(ElasticsearchSearchSortCollector collector, SearchSort sort) {
        ElasticsearchSearchSort elasticsearchSort = ElasticsearchSearchSort.from(this.searchContext, sort);
        elasticsearchSort.toJsonSorts(collector);
    }

    public ScoreSortBuilder score() {
        return new ElasticsearchScoreSort.Builder(this.searchContext);
    }

    public FieldSortBuilder field(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(SortTypeKeys.FIELD, this.searchContext);
    }

    public DistanceSortBuilder distance(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(SortTypeKeys.DISTANCE, this.searchContext);
    }

    public SearchSort indexOrder() {
        return new ElasticsearchIndexOrderSort(this.searchContext);
    }

    public CompositeSortBuilder composite() {
        return new ElasticsearchCompositeSort.Builder(this.searchContext);
    }

    @Override
    public ElasticsearchSearchSort fromJson(JsonObject jsonObject) {
        return new ElasticsearchUserProvidedJsonSort(this.searchContext, jsonObject);
    }

    @Override
    public ElasticsearchSearchSort fromJson(String jsonString) {
        return this.fromJson((JsonObject)this.searchContext.userFacingGson().fromJson(jsonString, JsonObject.class));
    }
}

