/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.dsl.impl;

import java.util.List;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.ElasticsearchExtension;
import org.hibernate.search.backend.elasticsearch.scope.impl.ElasticsearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchQueryElementCollector;
import org.hibernate.search.backend.elasticsearch.search.predicate.dsl.ElasticsearchSearchPredicateFactory;
import org.hibernate.search.backend.elasticsearch.search.projection.dsl.ElasticsearchSearchProjectionFactory;
import org.hibernate.search.backend.elasticsearch.search.query.dsl.ElasticsearchSearchQueryOptionsStep;
import org.hibernate.search.backend.elasticsearch.search.query.dsl.ElasticsearchSearchQuerySelectStep;
import org.hibernate.search.backend.elasticsearch.search.query.dsl.ElasticsearchSearchQueryWhereStep;
import org.hibernate.search.backend.elasticsearch.search.query.dsl.impl.ElasticsearchSearchQueryOptionsStepImpl;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryBuilder;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.ProjectionFinalStep;
import org.hibernate.search.engine.search.query.dsl.spi.AbstractSearchQuerySelectStep;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

public class ElasticsearchSearchQuerySelectStepImpl<R, E, LOS>
extends AbstractSearchQuerySelectStep<ElasticsearchSearchQueryOptionsStep<E, LOS>, R, E, LOS, ElasticsearchSearchProjectionFactory<R, E>, ElasticsearchSearchPredicateFactory, ElasticsearchSearchQueryElementCollector>
implements ElasticsearchSearchQuerySelectStep<R, E, LOS> {
    private final ElasticsearchIndexScope indexScope;
    private final BackendSessionContext sessionContext;
    private final LoadingContextBuilder<R, E, LOS> loadingContextBuilder;

    public ElasticsearchSearchQuerySelectStepImpl(ElasticsearchIndexScope indexScope, BackendSessionContext sessionContext, LoadingContextBuilder<R, E, LOS> loadingContextBuilder) {
        this.indexScope = indexScope;
        this.sessionContext = sessionContext;
        this.loadingContextBuilder = loadingContextBuilder;
    }

    @Override
    public ElasticsearchSearchQueryWhereStep<E, LOS> selectEntity() {
        SearchQueryBuilder builder = this.indexScope.searchQueryBuilderFactory().selectEntity(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder);
        return this.createSearchQueryContext((ElasticsearchSearchQueryBuilder)builder);
    }

    @Override
    public ElasticsearchSearchQueryWhereStep<R, LOS> selectEntityReference() {
        SearchQueryBuilder builder = this.indexScope.searchQueryBuilderFactory().selectEntityReference(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder);
        return this.createSearchQueryContext((ElasticsearchSearchQueryBuilder)builder);
    }

    @Override
    public <P> ElasticsearchSearchQueryWhereStep<P, LOS> select(Function<? super ElasticsearchSearchProjectionFactory<R, E>, ? extends ProjectionFinalStep<P>> projectionContributor) {
        ElasticsearchSearchProjectionFactory factoryContext = (ElasticsearchSearchProjectionFactory)this.createDefaultProjectionFactory().extension(ElasticsearchExtension.get());
        SearchProjection projection = projectionContributor.apply(factoryContext).toProjection();
        return this.select(projection);
    }

    @Override
    public <P> ElasticsearchSearchQueryWhereStep<P, LOS> select(SearchProjection<P> projection) {
        SearchQueryBuilder builder = this.indexScope.searchQueryBuilderFactory().select(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder, (SearchProjection)projection);
        return this.createSearchQueryContext((ElasticsearchSearchQueryBuilder)builder);
    }

    @Override
    public ElasticsearchSearchQueryWhereStep<List<?>, LOS> select(SearchProjection<?> ... projections) {
        SearchQueryBuilder builder = this.indexScope.searchQueryBuilderFactory().select(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder, (SearchProjection[])projections);
        return this.createSearchQueryContext((ElasticsearchSearchQueryBuilder)builder);
    }

    public ElasticsearchSearchQueryOptionsStep<E, LOS> where(SearchPredicate predicate) {
        return (ElasticsearchSearchQueryOptionsStep)this.selectEntity().where(predicate);
    }

    public ElasticsearchSearchQueryOptionsStep<E, LOS> where(Function<? super ElasticsearchSearchPredicateFactory, ? extends PredicateFinalStep> predicateContributor) {
        return (ElasticsearchSearchQueryOptionsStep)this.selectEntity().where(predicateContributor);
    }

    protected ElasticsearchIndexScope indexScope() {
        return this.indexScope;
    }

    protected BackendSessionContext sessionContext() {
        return this.sessionContext;
    }

    protected LoadingContextBuilder<R, E, LOS> loadingContextBuilder() {
        return this.loadingContextBuilder;
    }

    private <H> ElasticsearchSearchQueryWhereStep<H, LOS> createSearchQueryContext(ElasticsearchSearchQueryBuilder<H> builder) {
        return new ElasticsearchSearchQueryOptionsStepImpl<H, LOS>(this.indexScope, builder, this.loadingContextBuilder);
    }
}

