/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchFieldContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchIndexesContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchObjectFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchBooleanPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchExistsPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchMatchAllPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchMatchIdPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchNestedPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateCollector;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSimpleQueryStringPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchUserProvidedJsonPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateTypeKeys;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.BooleanPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.ExistsPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchAllPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchIdPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.NestedPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.PhrasePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinCirclePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.WildcardPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchSearchPredicateBuilderFactoryImpl
implements ElasticsearchSearchPredicateBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchSearchContext searchContext;
    private final ElasticsearchSearchIndexesContext indexes;

    public ElasticsearchSearchPredicateBuilderFactoryImpl(ElasticsearchSearchContext searchContext) {
        this.searchContext = searchContext;
        this.indexes = searchContext.indexes();
    }

    public void contribute(ElasticsearchSearchPredicateCollector collector, SearchPredicate predicate) {
        ElasticsearchSearchPredicate lucenePredicate = ElasticsearchSearchPredicate.from(this.searchContext, predicate);
        collector.collectPredicate(lucenePredicate.toJsonQuery(collector.getRootPredicateContext()));
    }

    public MatchAllPredicateBuilder matchAll() {
        return new ElasticsearchMatchAllPredicate.Builder(this.searchContext);
    }

    public MatchIdPredicateBuilder id() {
        return new ElasticsearchMatchIdPredicate.Builder(this.searchContext);
    }

    public BooleanPredicateBuilder bool() {
        return new ElasticsearchBooleanPredicate.Builder(this.searchContext);
    }

    public MatchPredicateBuilder match(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(PredicateTypeKeys.MATCH, this.searchContext);
    }

    public RangePredicateBuilder range(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(PredicateTypeKeys.RANGE, this.searchContext);
    }

    public PhrasePredicateBuilder phrase(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(PredicateTypeKeys.PHRASE, this.searchContext);
    }

    public WildcardPredicateBuilder wildcard(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(PredicateTypeKeys.WILDCARD, this.searchContext);
    }

    public SimpleQueryStringPredicateBuilder simpleQueryString() {
        return new ElasticsearchSimpleQueryStringPredicate.Builder(this.searchContext);
    }

    public ExistsPredicateBuilder exists(String absoluteFieldPath) {
        ElasticsearchSearchFieldContext field = this.indexes.field(absoluteFieldPath);
        if (field.isObjectField()) {
            return new ElasticsearchExistsPredicate.Builder(this.searchContext, absoluteFieldPath, field.nestedPathHierarchy());
        }
        return field.queryElement(PredicateTypeKeys.EXISTS, this.searchContext);
    }

    public SpatialWithinCirclePredicateBuilder spatialWithinCircle(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(PredicateTypeKeys.SPATIAL_WITHIN_CIRCLE, this.searchContext);
    }

    public SpatialWithinPolygonPredicateBuilder spatialWithinPolygon(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(PredicateTypeKeys.SPATIAL_WITHIN_POLYGON, this.searchContext);
    }

    public SpatialWithinBoundingBoxPredicateBuilder spatialWithinBoundingBox(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(PredicateTypeKeys.SPATIAL_WITHIN_BOUNDING_BOX, this.searchContext);
    }

    public NestedPredicateBuilder nested(String absoluteFieldPath) {
        ElasticsearchSearchObjectFieldContext field = this.indexes.field(absoluteFieldPath).toObjectField();
        if (!field.nested()) {
            throw log.nonNestedFieldForNestedQuery(absoluteFieldPath, EventContexts.fromIndexNames(this.indexes.hibernateSearchIndexNames()));
        }
        return new ElasticsearchNestedPredicate.Builder(this.searchContext, absoluteFieldPath, field.nestedPathHierarchy());
    }

    @Override
    public ElasticsearchSearchPredicate fromJson(JsonObject jsonObject) {
        return new ElasticsearchUserProvidedJsonPredicate(this.searchContext, jsonObject);
    }

    @Override
    public ElasticsearchSearchPredicate fromJson(String jsonString) {
        return this.fromJson((JsonObject)this.searchContext.userFacingGson().fromJson(jsonString, JsonObject.class));
    }
}

