/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.NestedPredicateBuilder;

class ElasticsearchNestedPredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private static final JsonAccessor<String> PATH_ACCESSOR = JsonAccessor.root().property("path").asString();
    private static final JsonAccessor<JsonObject> QUERY_ACCESSOR = JsonAccessor.root().property("query").asObject();
    private final ElasticsearchSearchPredicate nestedPredicate;

    private ElasticsearchNestedPredicate(Builder builder) {
        super(builder);
        this.nestedPredicate = builder.nestedPredicate;
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        PredicateRequestContext nestedContext = context.withNestedPath(this.absoluteFieldPath);
        PATH_ACCESSOR.set(innerObject, this.absoluteFieldPath);
        QUERY_ACCESSOR.set(innerObject, this.nestedPredicate.toJsonQuery(nestedContext));
        outerObject.add("nested", (JsonElement)innerObject);
        return outerObject;
    }

    static class Builder
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements NestedPredicateBuilder {
        private ElasticsearchSearchPredicate nestedPredicate;

        Builder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy) {
            super(searchContext, absoluteFieldPath, nestedPathHierarchy.subList(0, nestedPathHierarchy.size() - 1));
        }

        public void nested(SearchPredicate nestedPredicate) {
            ElasticsearchSearchPredicate elasticsearchPredicate = ElasticsearchSearchPredicate.from(this.searchContext, nestedPredicate);
            elasticsearchPredicate.checkNestableWithin(this.absoluteFieldPath);
            this.nestedPredicate = elasticsearchPredicate;
        }

        public SearchPredicate build() {
            return new ElasticsearchNestedPredicate(this);
        }
    }
}

