/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.backend.elasticsearch.common.impl.DocumentIdHelper;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.search.impl.ElasticsearchSearchSyntax;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchIndexesContext;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentFieldValueConvertContextImpl;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContextImpl;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;

public final class ElasticsearchSearchContext {
    private final ToDocumentIdentifierValueConvertContext toDocumentIdentifierValueConvertContext;
    private final ToDocumentFieldValueConvertContext toDocumentFieldValueConvertContext;
    private final Gson userFacingGson;
    private final ElasticsearchSearchSyntax searchSyntax;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final TimingSource timingSource;
    private final ElasticsearchSearchIndexesContext indexes;

    public ElasticsearchSearchContext(BackendMappingContext mappingContext, Gson userFacingGson, ElasticsearchSearchSyntax searchSyntax, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchSearchIndexesContext indexes, TimingSource timingSource) {
        this.toDocumentIdentifierValueConvertContext = new ToDocumentIdentifierValueConvertContextImpl(mappingContext);
        this.toDocumentFieldValueConvertContext = new ToDocumentFieldValueConvertContextImpl(mappingContext);
        this.userFacingGson = userFacingGson;
        this.searchSyntax = searchSyntax;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.timingSource = timingSource;
        this.indexes = indexes;
    }

    public ToDocumentIdentifierValueConvertContext toDocumentIdentifierValueConvertContext() {
        return this.toDocumentIdentifierValueConvertContext;
    }

    public ToDocumentFieldValueConvertContext toDocumentFieldValueConvertContext() {
        return this.toDocumentFieldValueConvertContext;
    }

    public Gson userFacingGson() {
        return this.userFacingGson;
    }

    public ElasticsearchSearchSyntax searchSyntax() {
        return this.searchSyntax;
    }

    public DocumentIdHelper documentIdHelper() {
        return this.multiTenancyStrategy.documentIdHelper();
    }

    public ElasticsearchSearchIndexesContext indexes() {
        return this.indexes;
    }

    public JsonObject filterOrNull(String tenantId) {
        return this.multiTenancyStrategy.filterOrNull(tenantId);
    }

    public TimeoutManager createTimeoutManager(Long timeout, TimeUnit timeUnit, boolean exceptionOnTimeout) {
        if (timeout != null && timeUnit != null) {
            if (exceptionOnTimeout) {
                return TimeoutManager.hardTimeout((TimingSource)this.timingSource, (long)timeout, (TimeUnit)timeUnit);
            }
            return TimeoutManager.softTimeout((TimingSource)this.timingSource, (long)timeout, (TimeUnit)timeUnit);
        }
        return TimeoutManager.noTimeout((TimingSource)this.timingSource);
    }
}

