/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchFieldContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchObjectFieldContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.search.impl.SearchQueryElementTypeKey;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchMultiIndexSearchValueFieldContext<F>
implements ElasticsearchSearchValueFieldContext<F>,
ElasticsearchSearchValueFieldTypeContext<F> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Set<String> indexNames;
    private final String absolutePath;
    private final List<ElasticsearchSearchValueFieldContext<F>> fieldForEachIndex;

    public ElasticsearchMultiIndexSearchValueFieldContext(Set<String> indexNames, String absolutePath, List<ElasticsearchSearchValueFieldContext<F>> fieldForEachIndex) {
        this.indexNames = indexNames;
        this.absolutePath = absolutePath;
        this.fieldForEachIndex = fieldForEachIndex;
    }

    @Override
    public boolean isObjectField() {
        return false;
    }

    @Override
    public ElasticsearchSearchObjectFieldContext toObjectField() {
        throw log.invalidIndexElementTypeValueFieldIsNotObjectField(this.absolutePath);
    }

    @Override
    public String absolutePath() {
        return this.absolutePath;
    }

    @Override
    public String[] absolutePathComponents() {
        return this.fieldForEachIndex.get(0).absolutePathComponents();
    }

    @Override
    public List<String> nestedPathHierarchy() {
        return this.getFromFieldIfCompatible(ElasticsearchSearchFieldContext::nestedPathHierarchy, Object::equals, "nestedPathHierarchy");
    }

    @Override
    public boolean multiValuedInRoot() {
        for (ElasticsearchSearchValueFieldContext<F> field : this.fieldForEachIndex) {
            if (!field.multiValuedInRoot()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ElasticsearchSearchValueFieldTypeContext<F> type() {
        return this;
    }

    public EventContext eventContext() {
        return this.indexesEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absolutePath));
    }

    private EventContext indexesEventContext() {
        return EventContexts.fromIndexNames(this.indexNames);
    }

    @Override
    public <T> T queryElement(SearchQueryElementTypeKey<T> key, ElasticsearchSearchContext searchContext) {
        ElasticsearchSearchValueFieldQueryElementFactory<T, F> factory = this.type().queryElementFactory(key);
        if (factory == null) {
            throw log.cannotUseQueryElementForField(this.absolutePath(), key.toString(), this.eventContext());
        }
        return factory.create(searchContext, this);
    }

    @Override
    public DslConverter<?, F> dslConverter() {
        return this.getFromTypeIfCompatible(ElasticsearchSearchValueFieldTypeContext::dslConverter, DslConverter::isCompatibleWith, "dslConverter");
    }

    @Override
    public DslConverter<F, F> rawDslConverter() {
        return this.getFromTypeIfCompatible(ElasticsearchSearchValueFieldTypeContext::rawDslConverter, DslConverter::isCompatibleWith, "rawDslConverter");
    }

    @Override
    public ProjectionConverter<F, ?> projectionConverter() {
        return this.getFromTypeIfCompatible(ElasticsearchSearchValueFieldTypeContext::projectionConverter, ProjectionConverter::isCompatibleWith, "projectionConverter");
    }

    @Override
    public ProjectionConverter<F, F> rawProjectionConverter() {
        return this.getFromTypeIfCompatible(ElasticsearchSearchValueFieldTypeContext::rawProjectionConverter, ProjectionConverter::isCompatibleWith, "rawProjectionConverter");
    }

    @Override
    public Optional<String> searchAnalyzerName() {
        return this.getFromTypeIfCompatible(ElasticsearchSearchValueFieldTypeContext::searchAnalyzerName, Object::equals, "searchAnalyzer");
    }

    @Override
    public Optional<String> normalizerName() {
        return this.getFromTypeIfCompatible(ElasticsearchSearchValueFieldTypeContext::normalizerName, Object::equals, "normalizer");
    }

    @Override
    public boolean hasNormalizerOnAtLeastOneIndex() {
        for (ElasticsearchSearchValueFieldContext<F> fieldContext : this.fieldForEachIndex) {
            if (!fieldContext.type().hasNormalizerOnAtLeastOneIndex()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> ElasticsearchSearchValueFieldQueryElementFactory<T, F> queryElementFactory(SearchQueryElementTypeKey<T> key) {
        ElasticsearchSearchValueFieldQueryElementFactory<T, F> factory = null;
        for (ElasticsearchSearchValueFieldContext<F> fieldContext : this.fieldForEachIndex) {
            ElasticsearchSearchValueFieldTypeContext<F> fieldType = fieldContext.type();
            ElasticsearchSearchValueFieldQueryElementFactory<T, F> factoryForFieldContext = fieldType.queryElementFactory(key);
            if (factory == null) {
                factory = factoryForFieldContext;
                continue;
            }
            this.checkFactoryCompatibility(key, factory, factoryForFieldContext);
        }
        return factory;
    }

    private <T> T getFromFieldIfCompatible(Function<ElasticsearchSearchValueFieldContext<F>, T> getter, BiPredicate<T, T> compatiblityChecker, String attributeName) {
        T attribute = null;
        for (ElasticsearchSearchValueFieldContext<F> fieldContext : this.fieldForEachIndex) {
            T attributeForFieldContext = getter.apply(fieldContext);
            if (attribute == null) {
                attribute = attributeForFieldContext;
                continue;
            }
            this.checkAttributeCompatibility(compatiblityChecker, attributeName, attribute, attributeForFieldContext);
        }
        return attribute;
    }

    private <T> T getFromTypeIfCompatible(Function<ElasticsearchSearchValueFieldTypeContext<F>, T> getter, BiPredicate<T, T> compatiblityChecker, String attributeName) {
        T attribute = null;
        for (ElasticsearchSearchValueFieldContext<F> fieldContext : this.fieldForEachIndex) {
            ElasticsearchSearchValueFieldTypeContext<F> fieldType = fieldContext.type();
            T attributeForFieldContext = getter.apply(fieldType);
            if (attribute == null) {
                attribute = attributeForFieldContext;
                continue;
            }
            this.checkAttributeCompatibility(compatiblityChecker, attributeName, attribute, attributeForFieldContext);
        }
        return attribute;
    }

    private <T> void checkFactoryCompatibility(SearchQueryElementTypeKey<T> key, ElasticsearchSearchValueFieldQueryElementFactory<T, F> factory1, ElasticsearchSearchValueFieldQueryElementFactory<T, F> factory2) {
        if (factory1 == null && factory2 == null) {
            return;
        }
        try {
            try {
                if (factory1 == null || factory2 == null) {
                    throw log.partialSupportForQueryElement(key.toString());
                }
                factory1.checkCompatibleWith(factory2);
            }
            catch (SearchException e) {
                throw log.inconsistentSupportForQueryElement(key.toString(), e.getMessage(), e);
            }
        }
        catch (SearchException e) {
            throw log.inconsistentConfigurationForFieldForSearch(this.absolutePath, e.getMessage(), this.indexesEventContext(), e);
        }
    }

    private <T> void checkAttributeCompatibility(BiPredicate<T, T> compatiblityChecker, String attributeName, T attribute1, T attribute2) {
        try {
            if (!compatiblityChecker.test(attribute1, attribute2)) {
                throw log.differentFieldAttribute(attributeName, attribute1, attribute2);
            }
        }
        catch (SearchException e) {
            throw log.inconsistentConfigurationForFieldForSearch(this.absolutePath, e.getMessage(), this.indexesEventContext(), e);
        }
    }
}

