/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.scope.impl;

import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregationBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchIndexesContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchQueryElementCollector;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilderFactoryImpl;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilderFactoryImpl;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.search.aggregation.spi.SearchAggregationBuilderFactory;

public class ElasticsearchIndexScope
implements IndexScope<ElasticsearchSearchQueryElementCollector> {
    private final ElasticsearchSearchContext searchContext;
    private final ElasticsearchSearchPredicateBuilderFactoryImpl searchPredicateFactory;
    private final ElasticsearchSearchSortBuilderFactoryImpl searchSortFactory;
    private final ElasticsearchSearchProjectionBuilderFactory searchProjectionFactory;
    private final ElasticsearchSearchAggregationBuilderFactory searchAggregationFactory;
    private final ElasticsearchSearchQueryBuilderFactory searchQueryFactory;

    public ElasticsearchIndexScope(BackendMappingContext mappingContext, SearchBackendContext backendContext, ElasticsearchSearchIndexesContext searchIndexesContext) {
        this.searchContext = backendContext.createSearchContext(mappingContext, searchIndexesContext);
        this.searchPredicateFactory = new ElasticsearchSearchPredicateBuilderFactoryImpl(this.searchContext);
        this.searchSortFactory = new ElasticsearchSearchSortBuilderFactoryImpl(this.searchContext);
        this.searchProjectionFactory = new ElasticsearchSearchProjectionBuilderFactory(backendContext.getSearchProjectionBackendContext(), this.searchContext);
        this.searchAggregationFactory = new ElasticsearchSearchAggregationBuilderFactory(this.searchContext);
        this.searchQueryFactory = new ElasticsearchSearchQueryBuilderFactory(backendContext, this.searchContext, this.searchProjectionFactory);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexNames=" + this.searchContext.indexes().hibernateSearchIndexNames() + "]";
    }

    public ElasticsearchSearchPredicateBuilderFactoryImpl searchPredicateBuilderFactory() {
        return this.searchPredicateFactory;
    }

    public ElasticsearchSearchSortBuilderFactoryImpl searchSortBuilderFactory() {
        return this.searchSortFactory;
    }

    public ElasticsearchSearchQueryBuilderFactory searchQueryBuilderFactory() {
        return this.searchQueryFactory;
    }

    public ElasticsearchSearchProjectionBuilderFactory searchProjectionFactory() {
        return this.searchProjectionFactory;
    }

    public SearchAggregationBuilderFactory<? super ElasticsearchSearchQueryElementCollector> searchAggregationFactory() {
        return this.searchAggregationFactory;
    }
}

