/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.schema.management.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.aliases.impl.IndexAliasDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchSchemaMigrator;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchSchemaValidator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchSchemaMigratorImpl
implements ElasticsearchSchemaMigrator {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchSchemaAccessor schemaAccessor;
    private final ElasticsearchSchemaValidator schemaValidator;

    public ElasticsearchSchemaMigratorImpl(ElasticsearchSchemaAccessor schemaAccessor, ElasticsearchSchemaValidator schemaValidator) {
        this.schemaAccessor = schemaAccessor;
        this.schemaValidator = schemaValidator;
    }

    @Override
    public CompletableFuture<?> migrate(URLEncodedString indexName, IndexMetadata expectedIndexMetadata, IndexMetadata actualIndexMetadata) {
        CompletableFuture<Object> aliasMigration = this.schemaValidator.isAliasesValid(expectedIndexMetadata, actualIndexMetadata) ? CompletableFuture.completedFuture(null) : this.doMigrateAliases(indexName, expectedIndexMetadata.getAliases());
        CompletionStage<Object> settingsMigration = this.schemaValidator.isSettingsValid(expectedIndexMetadata, actualIndexMetadata) ? aliasMigration : aliasMigration.thenCompose(ignored -> this.doMigrateSettings(indexName, expectedIndexMetadata.getSettings()));
        CompletionStage<Object> mappingMigration = this.schemaValidator.isMappingValid(expectedIndexMetadata, actualIndexMetadata) ? settingsMigration : ((CompletableFuture)settingsMigration).thenCompose(ignored -> this.doMigrateMapping(indexName, expectedIndexMetadata.getMapping()));
        return ((CompletableFuture)mappingMigration).exceptionally(Futures.handler(e -> {
            throw log.schemaUpdateFailed(indexName, e.getMessage(), Throwables.expectException((Throwable)e));
        }));
    }

    private CompletableFuture<?> doMigrateAliases(URLEncodedString indexName, Map<String, IndexAliasDefinition> aliases) {
        return this.schemaAccessor.updateAliases(indexName, aliases);
    }

    private CompletableFuture<?> doMigrateSettings(URLEncodedString indexName, IndexSettings settings) {
        return this.schemaAccessor.closeIndex(indexName).thenCompose(ignored -> Futures.whenCompleteExecute(this.schemaAccessor.updateSettings(indexName, settings), () -> this.schemaAccessor.openIndex(indexName)));
    }

    private CompletableFuture<?> doMigrateMapping(URLEncodedString indexName, RootTypeMapping mapping) {
        return this.schemaAccessor.updateMapping(indexName, mapping);
    }
}

