/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexManagerImpl;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.scope.impl.ElasticsearchIndexScope;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopeSearchIndexesContext;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchIndexScopeBuilder
implements IndexScopeBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexManagerBackendContext backendContext;
    private final BackendMappingContext mappingContext;
    private final Set<ElasticsearchIndexManagerImpl> indexManagers = new LinkedHashSet<ElasticsearchIndexManagerImpl>();

    ElasticsearchIndexScopeBuilder(IndexManagerBackendContext backendContext, BackendMappingContext mappingContext, ElasticsearchIndexManagerImpl indexManager) {
        this.backendContext = backendContext;
        this.mappingContext = mappingContext;
        this.indexManagers.add(indexManager);
    }

    void add(IndexManagerBackendContext backendContext, ElasticsearchIndexManagerImpl indexManager) {
        if (!this.backendContext.equals(backendContext)) {
            throw log.cannotMixElasticsearchScopeWithOtherBackend(this, indexManager, backendContext.getEventContext());
        }
        this.indexManagers.add(indexManager);
    }

    public IndexScope<?> build() {
        Set indexModels = this.indexManagers.stream().map(ElasticsearchIndexManagerImpl::model).collect(Collectors.toCollection(LinkedHashSet::new));
        ElasticsearchScopeSearchIndexesContext searchIndexesContext = new ElasticsearchScopeSearchIndexesContext(indexModels);
        return new ElasticsearchIndexScope(this.mappingContext, this.backendContext, searchIndexesContext);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "backendContext=" + this.backendContext + ", indexManagers=" + this.indexManagers + "]";
    }
}

