/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.index.settings.esnative.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.GetIndexMetadataWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSimpleElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.util.common.AssertionFailure;

public class GetIndexMetadataWork
extends AbstractSimpleElasticsearchWork<IndexMetadata> {
    private static final TypeToken<Map<String, RootTypeMapping>> STRING_TO_TYPE_MAPPING_MAP_TYPE_TOKEN = new TypeToken<Map<String, RootTypeMapping>>(){};
    private final URLEncodedString indexName;
    private final URLEncodedString typeName;

    private GetIndexMetadataWork(Builder builder) {
        super(builder);
        this.indexName = builder.indexName;
        this.typeName = builder.typeName;
    }

    @Override
    protected IndexMetadata generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        JsonObject body = response.getBody();
        JsonElement index = body.get(this.indexName.original);
        if (index == null || !index.isJsonObject()) {
            throw new AssertionFailure("Elasticsearch API call succeeded, but the requested index wasn't mentioned in the result: " + body);
        }
        JsonObject indexAsObject = index.getAsJsonObject();
        IndexMetadata indexMetadata = new IndexMetadata();
        indexMetadata.setName(this.indexName);
        indexMetadata.setSettings(this.getSettings(context, indexAsObject));
        indexMetadata.setMapping(this.getMapping(context, indexAsObject));
        return indexMetadata;
    }

    private IndexSettings getSettings(ElasticsearchWorkExecutionContext context, JsonObject index) {
        JsonElement settings = index.get("settings");
        if (settings == null || !settings.isJsonObject()) {
            throw new AssertionFailure("Elasticsearch API call succeeded, but the requested settings weren't mentioned in the result: " + index);
        }
        JsonElement indexSettings = settings.getAsJsonObject().get("index");
        if (indexSettings != null) {
            GsonProvider gsonProvider = context.getGsonProvider();
            return (IndexSettings)gsonProvider.getGson().fromJson(indexSettings, IndexSettings.class);
        }
        return new IndexSettings();
    }

    private RootTypeMapping getMapping(ElasticsearchWorkExecutionContext context, JsonObject index) {
        JsonElement mappings = index.get("mappings");
        if (mappings != null) {
            GsonProvider gsonProvider = context.getGsonProvider();
            if (this.typeName != null) {
                Type mapType = STRING_TO_TYPE_MAPPING_MAP_TYPE_TOKEN.getType();
                Map mappingsMap = (Map)gsonProvider.getGson().fromJson(mappings, mapType);
                return (RootTypeMapping)mappingsMap.get(this.typeName.original);
            }
            return (RootTypeMapping)gsonProvider.getGson().fromJson(mappings, RootTypeMapping.class);
        }
        return null;
    }

    public static class Builder
    extends AbstractSimpleElasticsearchWork.AbstractBuilder<Builder>
    implements GetIndexMetadataWorkBuilder {
        private final URLEncodedString indexName;
        private final URLEncodedString typeName;
        private final Boolean includeTypeName;

        public static Builder forElasticsearch66AndBelow(URLEncodedString indexName, URLEncodedString typeName) {
            return new Builder(indexName, typeName, null);
        }

        public static Builder forElasticsearch67(URLEncodedString indexName, URLEncodedString typeName) {
            return new Builder(indexName, typeName, true);
        }

        public static Builder forElasticsearch7AndAbove(URLEncodedString indexName) {
            return new Builder(indexName, null, null);
        }

        private Builder(URLEncodedString indexName, URLEncodedString typeName, Boolean includeTypeName) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.indexName = indexName;
            this.typeName = typeName;
            this.includeTypeName = includeTypeName;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.get().pathComponent(this.indexName);
            if (this.includeTypeName != null) {
                builder.param("include_type_name", this.includeTypeName);
            }
            return builder.build();
        }

        @Override
        public GetIndexMetadataWork build() {
            return new GetIndexMetadataWork(this);
        }
    }
}

