/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.FlushWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.RefreshWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSimpleElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;

public class FlushWork
extends AbstractSimpleElasticsearchWork<Void> {
    private final ElasticsearchWork<?> refreshWork;

    protected FlushWork(Builder builder) {
        super(builder);
        this.refreshWork = builder.buildRefreshWork();
    }

    @Override
    protected CompletableFuture<?> afterSuccess(ElasticsearchWorkExecutionContext executionContext) {
        return this.refreshWork.execute(executionContext);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        return null;
    }

    public static class Builder
    extends AbstractSimpleElasticsearchWork.AbstractBuilder<Builder>
    implements FlushWorkBuilder {
        private final RefreshWorkBuilder refreshWorkBuilder;
        private final Set<URLEncodedString> indexNames = new HashSet<URLEncodedString>();

        public Builder(ElasticsearchWorkBuilderFactory workFactory) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.refreshWorkBuilder = workFactory.refresh();
        }

        @Override
        public Builder index(URLEncodedString indexName) {
            this.indexNames.add(indexName);
            this.refreshWorkBuilder.index(indexName);
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.post();
            if (!this.indexNames.isEmpty()) {
                builder.multiValuedPathComponent(this.indexNames);
            }
            builder.pathComponent(Paths._FLUSH);
            return builder.build();
        }

        protected ElasticsearchWork<?> buildRefreshWork() {
            return this.refreshWorkBuilder.build();
        }

        @Override
        public FlushWork build() {
            return new FlushWork(this);
        }
    }
}

