/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSimpleElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkAggregator;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractSimpleBulkableElasticsearchWork<R>
extends AbstractSimpleElasticsearchWork<R>
implements BulkableElasticsearchWork<R> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final JsonObject bulkableActionMetadata;

    protected AbstractSimpleBulkableElasticsearchWork(AbstractBuilder<?> builder) {
        super(builder);
        this.bulkableActionMetadata = builder.buildBulkableActionMetadata();
    }

    @Override
    public DocumentRefreshStrategy getRefreshStrategy() {
        return this.refreshStrategy;
    }

    @Override
    public JsonObject getBulkableActionMetadata() {
        return this.bulkableActionMetadata;
    }

    @Override
    public JsonObject getBulkableActionBody() {
        List<JsonObject> bodyParts = this.request.getBodyParts();
        if (!bodyParts.isEmpty()) {
            if (bodyParts.size() > 1) {
                throw new AssertionFailure("Found a bulkable action with multiple body parts: " + bodyParts);
            }
            return bodyParts.get(0);
        }
        return null;
    }

    @Override
    public CompletableFuture<R> handleBulkResult(ElasticsearchWorkExecutionContext context, JsonObject bulkResponseItem) {
        return Futures.create(() -> this.handleResult(context, bulkResponseItem));
    }

    @Override
    protected final CompletableFuture<?> beforeExecute(ElasticsearchWorkExecutionContext executionContext, ElasticsearchRequest request) {
        return super.beforeExecute(executionContext, request);
    }

    @Override
    public CompletableFuture<R> aggregate(ElasticsearchWorkAggregator aggregator) {
        return aggregator.addBulkable(this);
    }

    protected abstract R generateResult(ElasticsearchWorkExecutionContext var1, JsonObject var2);

    private CompletableFuture<R> handleResult(ElasticsearchWorkExecutionContext executionContext, JsonObject bulkResponseItem) {
        Object result;
        try {
            this.resultAssessor.checkSuccess(bulkResponseItem);
            result = this.generateResult(executionContext, bulkResponseItem);
            switch (this.refreshStrategy) {
                case FORCE: {
                    executionContext.registerIndexToRefresh(this.refreshedIndexName);
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            throw log.elasticsearchBulkedRequestFailed(this.getBulkableActionMetadata(), bulkResponseItem, e.getMessage(), e);
        }
        return ((CompletableFuture)this.afterSuccess(executionContext).exceptionally(Futures.handler(throwable -> {
            throw log.elasticsearchBulkedRequestFailed(this.getBulkableActionMetadata(), bulkResponseItem, throwable.getMessage(), Throwables.expectException((Throwable)throwable));
        }))).thenApply(ignored -> result);
    }

    protected static abstract class AbstractBuilder<B>
    extends AbstractSimpleElasticsearchWork.AbstractBuilder<B> {
        public AbstractBuilder(URLEncodedString dirtiedIndexName, ElasticsearchRequestSuccessAssessor resultAssessor) {
            super(dirtiedIndexName, resultAssessor);
        }

        protected abstract JsonObject buildBulkableActionMetadata();
    }
}

