/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.execution.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;

public class ElasticsearchIndexWorkspace
implements IndexWorkspace {
    private final ElasticsearchWorkBuilderFactory builderFactory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchWorkOrchestrator orchestrator;
    private final URLEncodedString indexName;
    private final DetachedBackendSessionContext sessionContext;

    public ElasticsearchIndexWorkspace(ElasticsearchWorkBuilderFactory builderFactory, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchWorkOrchestrator orchestrator, WorkExecutionIndexManagerContext indexManagerContext, DetachedBackendSessionContext sessionContext) {
        this.builderFactory = builderFactory;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.orchestrator = orchestrator;
        this.indexName = indexManagerContext.getElasticsearchIndexName();
        this.sessionContext = sessionContext;
    }

    public CompletableFuture<?> optimize() {
        return this.orchestrator.submit(this.builderFactory.optimize().index(this.indexName).build());
    }

    public CompletableFuture<?> purge() {
        JsonObject matchAll = new JsonObject();
        matchAll.add("match_all", (JsonElement)new JsonObject());
        JsonObject document = new JsonObject();
        document.add("query", (JsonElement)this.multiTenancyStrategy.decorateJsonQuery(matchAll, this.sessionContext.getTenantIdentifier()));
        return this.orchestrator.submit(this.builderFactory.deleteByQuery(this.indexName, document).build());
    }

    public CompletableFuture<?> flush() {
        return this.orchestrator.submit(this.builderFactory.flush().index(this.indexName).build());
    }
}

