/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.execution.impl;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.DeleteWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.IndexWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.ElasticsearchIndexingPlanWorkSet;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.elasticsearch.work.impl.SingleDocumentElasticsearchWork;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlanExecutionReport;

public class ElasticsearchIndexIndexingPlan
implements IndexIndexingPlan<ElasticsearchDocumentObjectBuilder> {
    private final ElasticsearchWorkBuilderFactory builderFactory;
    private final ElasticsearchWorkOrchestrator orchestrator;
    private final WorkExecutionIndexManagerContext indexManagerContext;
    private final DocumentRefreshStrategy refreshStrategy;
    private final String tenantId;
    private final List<SingleDocumentElasticsearchWork<?>> works = new ArrayList();

    public ElasticsearchIndexIndexingPlan(ElasticsearchWorkBuilderFactory builderFactory, ElasticsearchWorkOrchestrator orchestrator, WorkExecutionIndexManagerContext indexManagerContext, DocumentRefreshStrategy refreshStrategy, BackendSessionContext sessionContext) {
        this.builderFactory = builderFactory;
        this.orchestrator = orchestrator;
        this.indexManagerContext = indexManagerContext;
        this.refreshStrategy = refreshStrategy;
        this.tenantId = sessionContext.getTenantIdentifier();
    }

    public void add(DocumentReferenceProvider referenceProvider, DocumentContributor<ElasticsearchDocumentObjectBuilder> documentContributor) {
        this.index(referenceProvider, documentContributor);
    }

    public void update(DocumentReferenceProvider referenceProvider, DocumentContributor<ElasticsearchDocumentObjectBuilder> documentContributor) {
        this.index(referenceProvider, documentContributor);
    }

    public void delete(DocumentReferenceProvider referenceProvider) {
        String elasticsearchId = this.indexManagerContext.toElasticsearchId(this.tenantId, referenceProvider.getIdentifier());
        String routingKey = referenceProvider.getRoutingKey();
        this.collect((SingleDocumentElasticsearchWork)((DeleteWorkBuilder)this.builderFactory.delete(this.indexManagerContext.getMappedTypeName(), this.indexManagerContext.getElasticsearchIndexName(), URLEncodedString.fromString(elasticsearchId), routingKey).refresh(this.refreshStrategy)).build());
    }

    public void process() {
    }

    public CompletableFuture<IndexIndexingPlanExecutionReport> executeAndReport() {
        try {
            CompletableFuture<IndexIndexingPlanExecutionReport> future = new CompletableFuture<IndexIndexingPlanExecutionReport>();
            this.orchestrator.submit(new ElasticsearchIndexingPlanWorkSet(this.works, future));
            CompletableFuture<IndexIndexingPlanExecutionReport> completableFuture = future;
            return completableFuture;
        }
        finally {
            this.works.clear();
        }
    }

    public void discard() {
        this.works.clear();
    }

    private void index(DocumentReferenceProvider referenceProvider, DocumentContributor<ElasticsearchDocumentObjectBuilder> documentContributor) {
        String id = referenceProvider.getIdentifier();
        String elasticsearchId = this.indexManagerContext.toElasticsearchId(this.tenantId, id);
        String routingKey = referenceProvider.getRoutingKey();
        JsonObject document = this.indexManagerContext.createDocument(this.tenantId, id, documentContributor);
        this.collect((SingleDocumentElasticsearchWork)((IndexWorkBuilder)this.builderFactory.index(this.indexManagerContext.getMappedTypeName(), this.indexManagerContext.getElasticsearchIndexName(), URLEncodedString.fromString(elasticsearchId), routingKey, document).refresh(this.refreshStrategy)).build());
    }

    private void collect(SingleDocumentElasticsearchWork<?> work) {
        this.works.add(work);
    }
}

