/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.impl;

import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.AbstractTypeMapping;
import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.types.aggregation.impl.ElasticsearchFieldAggregationBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.IndexFieldType;

public class ElasticsearchIndexFieldType<F>
implements IndexFieldType<F> {
    private final ElasticsearchFieldCodec<F> codec;
    private final ElasticsearchFieldPredicateBuilderFactory predicateBuilderFactory;
    private final ElasticsearchFieldSortBuilderFactory sortBuilderFactory;
    private final ElasticsearchFieldProjectionBuilderFactory projectionBuilderFactory;
    private final ElasticsearchFieldAggregationBuilderFactory aggregationBuilderFactory;
    private final PropertyMapping mapping;

    public ElasticsearchIndexFieldType(ElasticsearchFieldCodec<F> codec, ElasticsearchFieldPredicateBuilderFactory predicateBuilderFactory, ElasticsearchFieldSortBuilderFactory sortBuilderFactory, ElasticsearchFieldProjectionBuilderFactory projectionBuilderFactory, ElasticsearchFieldAggregationBuilderFactory aggregationBuilderFactory, PropertyMapping mapping) {
        this.codec = codec;
        this.predicateBuilderFactory = predicateBuilderFactory;
        this.sortBuilderFactory = sortBuilderFactory;
        this.projectionBuilderFactory = projectionBuilderFactory;
        this.aggregationBuilderFactory = aggregationBuilderFactory;
        this.mapping = mapping;
    }

    public ElasticsearchIndexSchemaFieldNode<F> addField(ElasticsearchIndexSchemaNodeCollector collector, ElasticsearchIndexSchemaObjectNode parentNode, AbstractTypeMapping parentMapping, String relativeFieldName, boolean multiValued) {
        ElasticsearchIndexSchemaFieldNode<F> schemaNode = new ElasticsearchIndexSchemaFieldNode<F>(parentNode, relativeFieldName, multiValued, this.codec, this.predicateBuilderFactory, this.sortBuilderFactory, this.projectionBuilderFactory, this.aggregationBuilderFactory);
        String absoluteFieldPath = parentNode.getAbsolutePath(relativeFieldName);
        collector.collect(absoluteFieldPath, schemaNode);
        parentMapping.addProperty(relativeFieldName, this.mapping);
        return schemaNode;
    }

    public void indexNullAs(F value) {
        this.mapping.setNullValue(this.codec.encode(value));
    }
}

