/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.aggregation.impl.ElasticsearchTextFieldAggregationBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchStringFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexFieldType;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchTextFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Aggregable;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.Norms;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.TermVector;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeOptionsStep;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchStringIndexFieldTypeOptionsStep
extends AbstractElasticsearchStandardIndexFieldTypeOptionsStep<ElasticsearchStringIndexFieldTypeOptionsStep, String>
implements StringIndexFieldTypeOptionsStep<ElasticsearchStringIndexFieldTypeOptionsStep> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private String analyzerName;
    private String searchAnalyzerName;
    private String normalizerName;
    private Projectable projectable = Projectable.DEFAULT;
    private Searchable searchable = Searchable.DEFAULT;
    private Norms norms = Norms.DEFAULT;
    private Sortable sortable = Sortable.DEFAULT;
    private Aggregable aggregable = Aggregable.DEFAULT;
    private String indexNullAs;
    private TermVector termVector = TermVector.DEFAULT;

    ElasticsearchStringIndexFieldTypeOptionsStep(ElasticsearchIndexFieldTypeBuildContext buildContext) {
        super(buildContext, String.class);
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep analyzer(String analyzerName) {
        this.analyzerName = analyzerName;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep searchAnalyzer(String searchAnalyzerName) {
        this.searchAnalyzerName = searchAnalyzerName;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep normalizer(String normalizerName) {
        this.normalizerName = normalizerName;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep projectable(Projectable projectable) {
        this.projectable = projectable;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep norms(Norms norms) {
        this.norms = norms;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep termVector(TermVector termVector) {
        this.termVector = termVector;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep indexNullAs(String indexNullAs) {
        this.indexNullAs = indexNullAs;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep searchable(Searchable searchable) {
        this.searchable = searchable;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeOptionsStep aggregable(Aggregable aggregable) {
        this.aggregable = aggregable;
        return this;
    }

    public IndexFieldType<String> toIndexFieldType() {
        PropertyMapping mapping = new PropertyMapping();
        boolean resolvedSortable = ElasticsearchStringIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = ElasticsearchStringIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = ElasticsearchStringIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        boolean resolvedAggregable = ElasticsearchStringIndexFieldTypeOptionsStep.resolveDefault(this.aggregable);
        mapping.setIndex(resolvedSearchable);
        if (this.analyzerName != null) {
            mapping.setType("text");
            mapping.setAnalyzer(this.analyzerName);
            mapping.setSearchAnalyzer(this.searchAnalyzerName);
            mapping.setTermVector(this.resolveTermVector());
            if (this.normalizerName != null) {
                throw log.cannotApplyAnalyzerAndNormalizer(this.analyzerName, this.normalizerName, this.getBuildContext().getEventContext());
            }
            if (resolvedSortable) {
                throw log.cannotUseAnalyzerOnSortableField(this.analyzerName, this.getBuildContext().getEventContext());
            }
            if (this.indexNullAs != null) {
                throw log.cannotUseIndexNullAsAndAnalyzer(this.analyzerName, this.indexNullAs, this.getBuildContext().getEventContext());
            }
            if (resolvedAggregable) {
                throw log.cannotUseAnalyzerOnAggregableField(this.analyzerName, this.getBuildContext().getEventContext());
            }
        } else {
            if (this.searchAnalyzerName != null) {
                throw log.searchAnalyzerWithoutAnalyzer(this.searchAnalyzerName, this.getBuildContext().getEventContext());
            }
            mapping.setType("keyword");
            mapping.setNormalizer(this.normalizerName);
            mapping.setDocValues(resolvedSortable || resolvedAggregable);
        }
        mapping.setStore(resolvedProjectable);
        mapping.setNorms(this.resolveNorms());
        if (this.indexNullAs != null) {
            mapping.setNullValue((JsonElement)new JsonPrimitive(this.indexNullAs));
        }
        DslConverter dslConverter = this.createDslConverter();
        DslConverter rawDslConverter = this.createRawDslConverter();
        ProjectionConverter projectionConverter = this.createProjectionConverter();
        ProjectionConverter rawProjectionConverter = this.createRawProjectionConverter();
        ElasticsearchStringFieldCodec codec = ElasticsearchStringFieldCodec.INSTANCE;
        return new ElasticsearchIndexFieldType<String>(codec, new ElasticsearchTextFieldPredicateBuilderFactory(resolvedSearchable, dslConverter, rawDslConverter, codec, mapping), new ElasticsearchStandardFieldSortBuilderFactory<String>(resolvedSortable, dslConverter, rawDslConverter, codec), new ElasticsearchStandardFieldProjectionBuilderFactory<String>(resolvedProjectable, projectionConverter, rawProjectionConverter, codec), new ElasticsearchTextFieldAggregationBuilderFactory(resolvedAggregable, dslConverter, rawDslConverter, projectionConverter, rawProjectionConverter, codec, this.analyzerName != null), mapping);
    }

    @Override
    protected ElasticsearchStringIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }

    private boolean resolveNorms() {
        switch (this.norms) {
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
            case DEFAULT: {
                return this.analyzerName != null;
            }
        }
        throw new AssertionFailure("Unexpected value for Norms: " + this.norms);
    }

    private String resolveTermVector() {
        switch (this.termVector) {
            case NO: 
            case DEFAULT: {
                return "no";
            }
        }
        return this.termVector.name().toLowerCase(Locale.ROOT);
    }
}

