/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchBigDecimalFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchScalarFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.engine.backend.types.dsl.ScaledNumberIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchBigDecimalIndexFieldTypeOptionsStep
extends AbstractElasticsearchScalarFieldTypeOptionsStep<ElasticsearchBigDecimalIndexFieldTypeOptionsStep, BigDecimal>
implements ScaledNumberIndexFieldTypeOptionsStep<ElasticsearchBigDecimalIndexFieldTypeOptionsStep, BigDecimal> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexFieldTypeDefaultsProvider defaultsProvider;
    private Integer decimalScale = null;

    ElasticsearchBigDecimalIndexFieldTypeOptionsStep(ElasticsearchIndexFieldTypeBuildContext buildContext, IndexFieldTypeDefaultsProvider defaultsProvider) {
        super(buildContext, BigDecimal.class, "scaled_float");
        this.defaultsProvider = defaultsProvider;
    }

    public ElasticsearchBigDecimalIndexFieldTypeOptionsStep decimalScale(int decimalScale) {
        this.decimalScale = decimalScale;
        return this.thisAsS();
    }

    @Override
    protected ElasticsearchFieldCodec<BigDecimal> complete(PropertyMapping mapping) {
        BigDecimal scalingFactor = BigDecimal.TEN.pow(this.resolveDecimalScale(), new MathContext(10, RoundingMode.HALF_UP));
        mapping.setScalingFactor(scalingFactor.doubleValue());
        return new ElasticsearchBigDecimalFieldCodec(scalingFactor);
    }

    @Override
    protected ElasticsearchBigDecimalIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }

    private int resolveDecimalScale() {
        if (this.decimalScale != null) {
            return this.decimalScale;
        }
        if (this.defaultsProvider.getDecimalScale() != null) {
            return this.defaultsProvider.getDecimalScale();
        }
        throw log.nullDecimalScale(this.getBuildContext().getEventContext());
    }
}

