/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexFieldType;
import org.hibernate.search.engine.backend.types.Aggregable;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.Sortable;

abstract class AbstractElasticsearchSimpleStandardFieldTypeOptionsStep<S extends AbstractElasticsearchSimpleStandardFieldTypeOptionsStep<?, F>, F>
extends AbstractElasticsearchStandardIndexFieldTypeOptionsStep<S, F> {
    private final String dataType;
    private Sortable sortable = Sortable.DEFAULT;
    protected boolean resolvedSortable;
    private Projectable projectable = Projectable.DEFAULT;
    protected boolean resolvedProjectable;
    private Searchable searchable = Searchable.DEFAULT;
    protected boolean resolvedSearchable;
    private Aggregable aggregable = Aggregable.DEFAULT;
    protected boolean resolvedAggregable;
    private F indexNullAs;

    AbstractElasticsearchSimpleStandardFieldTypeOptionsStep(ElasticsearchIndexFieldTypeBuildContext buildContext, Class<F> fieldType, String dataType) {
        super(buildContext, fieldType);
        this.dataType = dataType;
    }

    public S projectable(Projectable projectable) {
        this.projectable = projectable;
        return (S)((AbstractElasticsearchSimpleStandardFieldTypeOptionsStep)this.thisAsS());
    }

    public S sortable(Sortable sortable) {
        this.sortable = sortable;
        return (S)((AbstractElasticsearchSimpleStandardFieldTypeOptionsStep)this.thisAsS());
    }

    public S indexNullAs(F indexNullAs) {
        this.indexNullAs = indexNullAs;
        return (S)((AbstractElasticsearchSimpleStandardFieldTypeOptionsStep)this.thisAsS());
    }

    public S searchable(Searchable searchable) {
        this.searchable = searchable;
        return (S)((AbstractElasticsearchSimpleStandardFieldTypeOptionsStep)this.thisAsS());
    }

    public S aggregable(Aggregable aggregable) {
        this.aggregable = aggregable;
        return (S)((AbstractElasticsearchSimpleStandardFieldTypeOptionsStep)this.thisAsS());
    }

    public final IndexFieldType<F> toIndexFieldType() {
        PropertyMapping mapping = new PropertyMapping();
        mapping.setType(this.dataType);
        this.resolvedSortable = AbstractElasticsearchSimpleStandardFieldTypeOptionsStep.resolveDefault(this.sortable);
        this.resolvedProjectable = AbstractElasticsearchSimpleStandardFieldTypeOptionsStep.resolveDefault(this.projectable);
        this.resolvedSearchable = AbstractElasticsearchSimpleStandardFieldTypeOptionsStep.resolveDefault(this.searchable);
        this.resolvedAggregable = AbstractElasticsearchSimpleStandardFieldTypeOptionsStep.resolveDefault(this.aggregable);
        mapping.setIndex(this.resolvedSearchable);
        mapping.setStore(this.resolvedProjectable);
        mapping.setDocValues(this.resolvedSortable || this.resolvedAggregable);
        ElasticsearchIndexFieldType<F> indexFieldType = this.toIndexFieldType(mapping);
        if (this.indexNullAs != null) {
            indexFieldType.indexNullAs(this.indexNullAs);
        }
        return indexFieldType;
    }

    protected abstract ElasticsearchIndexFieldType<F> toIndexFieldType(PropertyMapping var1);
}

