/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.AbstractElasticsearchJavaTimeFieldCodec;

public class ElasticsearchLocalDateFieldCodec
extends AbstractElasticsearchJavaTimeFieldCodec<LocalDate> {
    public ElasticsearchLocalDateFieldCodec(DateTimeFormatter delegate) {
        super(delegate);
    }

    @Override
    protected LocalDate nullUnsafeParse(String stringValue) {
        return LocalDate.parse(stringValue, this.formatter);
    }

    @Override
    protected Long nullUnsafeScalar(LocalDate value) {
        return value.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
    }
}

