/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.cfg.spi.NumberScaleConstants;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchBigDecimalFieldCodec
implements ElasticsearchFieldCodec<BigDecimal> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BigDecimal scalingFactor;

    public ElasticsearchBigDecimalFieldCodec(BigDecimal scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    @Override
    public JsonElement encode(BigDecimal value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        if (this.isTooLarge(value)) {
            throw log.scaledNumberTooLarge(value);
        }
        return new JsonPrimitive((Number)value);
    }

    @Override
    public BigDecimal decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return JsonElementTypes.BIG_DECIMAL.fromElement(element);
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElasticsearchBigDecimalFieldCodec other = (ElasticsearchBigDecimalFieldCodec)obj;
        return this.scalingFactor.compareTo(other.scalingFactor) == 0;
    }

    private boolean isTooLarge(BigDecimal value) {
        BigDecimal scaled = value.multiply(this.scalingFactor);
        return scaled.compareTo(NumberScaleConstants.MIN_LONG_AS_BIGDECIMAL) < 0 || scaled.compareTo(NumberScaleConstants.MAX_LONG_AS_BIGDECIMAL) > 0;
    }
}

