/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.aggregation.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchRangeAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchTermsAggregation;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.types.aggregation.impl.ElasticsearchFieldAggregationBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.aggregation.spi.RangeAggregationBuilder;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchStandardFieldAggregationBuilderFactory<F>
implements ElasticsearchFieldAggregationBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final boolean aggregable;
    private final DslConverter<?, ? extends F> toFieldValueConverter;
    private final DslConverter<? super F, ? extends F> rawToFieldValueConverter;
    private final ProjectionConverter<? super F, ?> fromFieldValueConverter;
    private final ProjectionConverter<? super F, F> rawFromFieldValueConverter;
    private final ElasticsearchFieldCodec<F> codec;

    public ElasticsearchStandardFieldAggregationBuilderFactory(boolean aggregable, DslConverter<?, ? extends F> toFieldValueConverter, DslConverter<? super F, ? extends F> rawToFieldValueConverter, ProjectionConverter<? super F, ?> fromFieldValueConverter, ProjectionConverter<? super F, F> rawFromFieldValueConverter, ElasticsearchFieldCodec<F> codec) {
        this.aggregable = aggregable;
        this.toFieldValueConverter = toFieldValueConverter;
        this.rawToFieldValueConverter = rawToFieldValueConverter;
        this.fromFieldValueConverter = fromFieldValueConverter;
        this.rawFromFieldValueConverter = rawFromFieldValueConverter;
        this.codec = codec;
    }

    @Override
    public <K> TermsAggregationBuilder<K> createTermsAggregationBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, Class<K> expectedType, ValueConvert convert) {
        ElasticsearchStandardFieldAggregationBuilderFactory.checkAggregable(absoluteFieldPath, this.aggregable);
        ProjectionConverter<F, K> fromFieldValueConverter = this.getFromFieldValueConverter(absoluteFieldPath, expectedType, convert);
        return new ElasticsearchTermsAggregation.Builder<F, K>(searchContext, absoluteFieldPath, fromFieldValueConverter, this.codec);
    }

    @Override
    public <K> RangeAggregationBuilder<K> createRangeAggregationBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, Class<K> expectedType, ValueConvert convert) {
        ElasticsearchStandardFieldAggregationBuilderFactory.checkAggregable(absoluteFieldPath, this.aggregable);
        DslConverter<?, F> toFieldValueConverter = this.getToFieldValueConverter(absoluteFieldPath, expectedType, convert);
        return new ElasticsearchRangeAggregation.Builder(searchContext, absoluteFieldPath, toFieldValueConverter, this.codec);
    }

    @Override
    public boolean hasCompatibleCodec(ElasticsearchFieldAggregationBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ElasticsearchStandardFieldAggregationBuilderFactory castedOther = (ElasticsearchStandardFieldAggregationBuilderFactory)other;
        return this.aggregable == castedOther.aggregable && this.codec.isCompatibleWith(castedOther.codec);
    }

    @Override
    public boolean hasCompatibleConverter(ElasticsearchFieldAggregationBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ElasticsearchStandardFieldAggregationBuilderFactory castedOther = (ElasticsearchStandardFieldAggregationBuilderFactory)other;
        return this.toFieldValueConverter.isCompatibleWith(castedOther.toFieldValueConverter) && this.fromFieldValueConverter.isCompatibleWith(castedOther.fromFieldValueConverter);
    }

    private static void checkAggregable(String absoluteFieldPath, boolean aggregable) {
        if (!aggregable) {
            throw log.nonAggregableField(absoluteFieldPath, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
    }

    private <T> DslConverter<?, ? extends F> getToFieldValueConverter(String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        Object result;
        switch (convert) {
            case NO: {
                result = this.rawToFieldValueConverter;
                break;
            }
            default: {
                result = this.toFieldValueConverter;
            }
        }
        if (!result.isValidInputType(expectedType)) {
            throw log.invalidAggregationInvalidType(absoluteFieldPath, expectedType, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
        return result;
    }

    private <T> ProjectionConverter<? super F, ? extends T> getFromFieldValueConverter(String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        Object result;
        switch (convert) {
            case NO: {
                result = this.rawFromFieldValueConverter;
                break;
            }
            default: {
                result = this.fromFieldValueConverter;
            }
        }
        if (!result.isConvertedTypeAssignableTo(expectedType)) {
            throw log.invalidAggregationInvalidType(absoluteFieldPath, expectedType, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
        return result;
    }
}

