/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.sort.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.AbstractElasticsearchSearchNestedSortBuilder;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilder;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchGeoPointFieldCodec;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;

public class ElasticsearchDistanceSortBuilder
extends AbstractElasticsearchSearchNestedSortBuilder
implements DistanceSortBuilder<ElasticsearchSearchSortBuilder> {
    private static final JsonObjectAccessor GEO_DISTANCE_ACCESSOR = JsonAccessor.root().property("_geo_distance").asObject();
    private final String absoluteFieldPath;
    private final GeoPoint location;

    public ElasticsearchDistanceSortBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy, GeoPoint location) {
        super(nestedPathHierarchy, searchContext.getJsonSyntaxHelper());
        this.absoluteFieldPath = absoluteFieldPath;
        this.location = location;
    }

    @Override
    protected void doBuildAndAddTo(ElasticsearchSearchSortCollector collector, JsonObject innerObject) {
        innerObject.add(this.absoluteFieldPath, ElasticsearchGeoPointFieldCodec.INSTANCE.encode(this.location));
        JsonObject outerObject = new JsonObject();
        GEO_DISTANCE_ACCESSOR.add(outerObject, innerObject);
        collector.collectDistanceSort((JsonElement)outerObject, this.absoluteFieldPath, this.location);
    }
}

