/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.sort.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchJsonSyntaxHelper;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.AbstractElasticsearchSearchSortBuilder;

public abstract class AbstractElasticsearchSearchNestedSortBuilder
extends AbstractElasticsearchSearchSortBuilder {
    private static final JsonAccessor<JsonElement> NESTED = JsonAccessor.root().property("nested");
    private static final JsonAccessor<JsonElement> PATH = JsonAccessor.root().property("path");
    private static final JsonAccessor<JsonElement> NESTED_PATH = JsonAccessor.root().property("nested_path");
    private final List<String> nestedPathHierarchy;
    private final ElasticsearchJsonSyntaxHelper jsonSyntaxHelper;

    public AbstractElasticsearchSearchNestedSortBuilder(List<String> nestedPathHierarchy, ElasticsearchJsonSyntaxHelper jsonSyntaxHelper) {
        this.nestedPathHierarchy = nestedPathHierarchy;
        this.jsonSyntaxHelper = jsonSyntaxHelper;
    }

    @Override
    protected void enrichInnerObject(JsonObject innerObject) {
        if (this.nestedPathHierarchy.isEmpty()) {
            return;
        }
        if (this.jsonSyntaxHelper.useOldSortNestedApi()) {
            String lastNestedPath = this.nestedPathHierarchy.get(this.nestedPathHierarchy.size() - 1);
            NESTED_PATH.set(innerObject, (JsonElement)new JsonPrimitive(lastNestedPath));
            return;
        }
        JsonObject nextNestedObjectTarget = innerObject;
        for (String nestedPath : this.nestedPathHierarchy) {
            JsonObject nestedObject = new JsonObject();
            PATH.set(nestedObject, (JsonElement)new JsonPrimitive(nestedPath));
            NESTED.set(nextNestedObjectTarget, (JsonElement)nestedObject);
            nextNestedObjectTarget = nestedObject;
        }
    }
}

