/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchRequestTransformer;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchRequestTransformerContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Contracts;

final class ElasticsearchSearchRequestTransformerContextImpl
implements ElasticsearchSearchRequestTransformerContext {
    private final ElasticsearchRequest originalRequest;
    private final JsonObject originalBody;
    private String path;
    private JsonObject potentiallyTransformedBody;
    private Map<String, String> potentiallyTransformedParametersMap;

    static Function<ElasticsearchRequest, ElasticsearchRequest> createTransformerFunction(ElasticsearchSearchRequestTransformer transformer) {
        if (transformer == null) {
            return null;
        }
        return request -> new ElasticsearchSearchRequestTransformerContextImpl((ElasticsearchRequest)request).apply(transformer);
    }

    private ElasticsearchSearchRequestTransformerContextImpl(ElasticsearchRequest originalRequest) {
        this.originalRequest = originalRequest;
        List<JsonObject> originalBodyParts = originalRequest.getBodyParts();
        if (originalBodyParts.size() != 1) {
            throw new AssertionFailure("Request transformation was applied to a request with no body part or more than one body parts. There is a bug in Hibernate Search, please report it.");
        }
        this.originalBody = originalBodyParts.get(0);
        this.path = originalRequest.getPath();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String newPath) {
        Contracts.assertNotNullNorEmpty((String)newPath, (String)"newPath");
        this.path = newPath;
    }

    @Override
    public Map<String, String> getParametersMap() {
        if (this.potentiallyTransformedParametersMap == null) {
            this.potentiallyTransformedParametersMap = new LinkedHashMap<String, String>(this.originalRequest.getParameters());
        }
        return this.potentiallyTransformedParametersMap;
    }

    @Override
    public JsonObject getBody() {
        if (this.potentiallyTransformedBody == null) {
            this.potentiallyTransformedBody = this.originalBody.deepCopy();
        }
        return this.potentiallyTransformedBody;
    }

    public ElasticsearchRequest apply(ElasticsearchSearchRequestTransformer transformer) {
        JsonObject body;
        transformer.transform(this);
        ElasticsearchRequest.Builder builder = ElasticsearchRequest.builder(this.originalRequest.getMethod());
        builder.wholeEncodedPath(this.path);
        Map<String, String> parameters = this.potentiallyTransformedParametersMap != null ? this.potentiallyTransformedParametersMap : this.originalRequest.getParameters();
        parameters.forEach(builder::param);
        JsonObject jsonObject = body = this.potentiallyTransformedBody != null ? this.potentiallyTransformedBody : this.originalBody;
        if (body != null) {
            builder.body(body);
        }
        return builder.build();
    }
}

