/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnknownTypeJsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

class ElasticsearchFieldProjection<F, V>
implements ElasticsearchSearchProjection<F, V> {
    private static final JsonArrayAccessor REQUEST_SOURCE_ACCESSOR = JsonAccessor.root().property("_source").asArray();
    private static final JsonObjectAccessor HIT_SOURCE_ACCESSOR = JsonAccessor.root().property("_source").asObject();
    private final Set<String> indexNames;
    private final String absoluteFieldPath;
    private final UnknownTypeJsonAccessor hitFieldValueAccessor;
    private final ProjectionConverter<? super F, V> converter;
    private final ElasticsearchFieldCodec<F> codec;

    ElasticsearchFieldProjection(Set<String> indexNames, String absoluteFieldPath, ProjectionConverter<? super F, V> converter, ElasticsearchFieldCodec<F> codec) {
        this.indexNames = indexNames;
        this.absoluteFieldPath = absoluteFieldPath;
        this.hitFieldValueAccessor = HIT_SOURCE_ACCESSOR.path(absoluteFieldPath);
        this.converter = converter;
        this.codec = codec;
    }

    @Override
    public void request(JsonObject requestBody, SearchProjectionRequestContext context) {
        JsonPrimitive fieldPathJson = new JsonPrimitive(this.absoluteFieldPath);
        REQUEST_SOURCE_ACCESSOR.addElementIfAbsent(requestBody, (JsonElement)fieldPathJson);
    }

    @Override
    public F extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject hit, SearchProjectionExtractContext context) {
        Optional fieldValue = this.hitFieldValueAccessor.get(hit);
        if (fieldValue.isPresent()) {
            return this.codec.decode((JsonElement)fieldValue.get());
        }
        return null;
    }

    @Override
    public V transform(LoadingResult<?> loadingResult, F extractedData, SearchProjectionTransformContext context) {
        FromDocumentFieldValueConvertContext convertContext = context.getFromDocumentFieldValueConvertContext();
        return (V)this.converter.convert(extractedData, convertContext);
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("absoluteFieldPath=").append(this.absoluteFieldPath).append("]");
        return sb.toString();
    }
}

