/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DocumentReferenceExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

public class ElasticsearchEntityProjection<E>
implements ElasticsearchSearchProjection<Object, E> {
    private final Set<String> indexNames;
    private final DocumentReferenceExtractionHelper helper;

    public ElasticsearchEntityProjection(Set<String> indexNames, DocumentReferenceExtractionHelper helper) {
        this.indexNames = indexNames;
        this.helper = helper;
    }

    @Override
    public void request(JsonObject requestBody, SearchProjectionRequestContext context) {
        this.helper.request(requestBody);
    }

    @Override
    public Object extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject hit, SearchProjectionExtractContext context) {
        return projectionHitMapper.planLoading(this.helper.extract(hit));
    }

    @Override
    public E transform(LoadingResult<?> loadingResult, Object extractedData, SearchProjectionTransformContext context) {
        Object loaded = loadingResult.getLoaded(extractedData);
        if (loaded == null) {
            context.reportFailedLoad();
        }
        return (E)loaded;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }
}

