/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import java.util.Set;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchDistanceToFieldProjection;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.DistanceToFieldProjectionBuilder;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.engine.spatial.GeoPoint;

public class ElasticsearchDistanceToFieldProjectionBuilder
implements DistanceToFieldProjectionBuilder {
    private final Set<String> indexNames;
    private final String absoluteFieldPath;
    private final String nestedPath;
    private final GeoPoint center;
    private DistanceUnit unit = DistanceUnit.METERS;

    public ElasticsearchDistanceToFieldProjectionBuilder(Set<String> indexNames, String absoluteFieldPath, String nestedPath, GeoPoint center) {
        this.indexNames = indexNames;
        this.absoluteFieldPath = absoluteFieldPath;
        this.nestedPath = nestedPath;
        this.center = center;
    }

    public DistanceToFieldProjectionBuilder unit(DistanceUnit unit) {
        this.unit = unit;
        return this;
    }

    public SearchProjection<Double> build() {
        return new ElasticsearchDistanceToFieldProjection(this.indexNames, this.absoluteFieldPath, this.nestedPath, this.center, this.unit);
    }
}

