/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.impl;

import com.google.gson.Gson;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopeModel;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchJsonSyntaxHelper;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentFieldValueConvertContextImpl;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContextImpl;

public final class ElasticsearchSearchContext {
    private final ToDocumentIdentifierValueConvertContext toDocumentIdentifierValueConvertContext;
    private final ToDocumentFieldValueConvertContext toDocumentFieldValueConvertContext;
    private final Gson userFacingGson;
    private final ElasticsearchJsonSyntaxHelper jsonSyntaxHelper;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchScopeModel scopeModel;

    public ElasticsearchSearchContext(BackendMappingContext mappingContext, Gson userFacingGson, ElasticsearchJsonSyntaxHelper jsonSyntaxHelper, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchScopeModel scopeModel) {
        this.toDocumentIdentifierValueConvertContext = new ToDocumentIdentifierValueConvertContextImpl(mappingContext);
        this.toDocumentFieldValueConvertContext = new ToDocumentFieldValueConvertContextImpl(mappingContext);
        this.userFacingGson = userFacingGson;
        this.jsonSyntaxHelper = jsonSyntaxHelper;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.scopeModel = scopeModel;
    }

    public ToDocumentIdentifierValueConvertContext getToDocumentIdentifierValueConvertContext() {
        return this.toDocumentIdentifierValueConvertContext;
    }

    public ToDocumentFieldValueConvertContext getToDocumentFieldValueConvertContext() {
        return this.toDocumentFieldValueConvertContext;
    }

    public Gson getUserFacingGson() {
        return this.userFacingGson;
    }

    public ElasticsearchJsonSyntaxHelper getJsonSyntaxHelper() {
        return this.jsonSyntaxHelper;
    }

    public String toElasticsearchId(String tenantId, String id) {
        return this.multiTenancyStrategy.toElasticsearchId(tenantId, id);
    }

    public Set<URLEncodedString> getIndexNames() {
        return this.scopeModel.getElasticsearchIndexNames();
    }

    public Set<String> getHibernateSearchIndexNames() {
        return this.scopeModel.getHibernateSearchIndexNames();
    }
}

