/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchRefreshableWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.result.impl.BulkResult;
import org.hibernate.search.backend.elasticsearch.work.result.impl.BulkResultItemExtractor;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchDefaultWorkSequenceBuilder
implements ElasticsearchWorkSequenceBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Supplier<ElasticsearchRefreshableWorkExecutionContext> contextSupplier;
    private final BulkResultExtractionStepImpl bulkResultExtractionStep = new BulkResultExtractionStepImpl();
    private CompletableFuture<?> currentlyBuildingSequenceTail;
    private SequenceContext currentlyBuildingSequenceContext;

    ElasticsearchDefaultWorkSequenceBuilder(Supplier<ElasticsearchRefreshableWorkExecutionContext> contextSupplier) {
        this.contextSupplier = contextSupplier;
    }

    @Override
    public void init(CompletableFuture<?> previous) {
        this.currentlyBuildingSequenceTail = previous.handle((ignoredResult, ignoredThrowable) -> null);
        this.currentlyBuildingSequenceContext = new SequenceContext(this.contextSupplier.get());
    }

    @Override
    public <T> CompletableFuture<T> addNonBulkExecution(ElasticsearchWork<T> work) {
        SequenceContext sequenceContext = this.currentlyBuildingSequenceContext;
        CompletableFuture workFutureForCaller = new CompletableFuture();
        CompletionStage handledWorkExecutionFuture = ((CompletableFuture)this.currentlyBuildingSequenceTail.whenComplete(Futures.handler((ignoredResult, throwable) -> {
            if (throwable != null) {
                sequenceContext.notifyWorkSkipped(work, (Throwable)throwable, workFutureForCaller);
            }
        }))).thenCompose(Futures.safeComposer(ignoredPreviousResult -> {
            CompletableFuture workExecutionFuture = work.execute(sequenceContext.executionContext);
            return this.addPostExecutionHandlers(work, workExecutionFuture, workFutureForCaller, sequenceContext);
        }));
        this.currentlyBuildingSequenceTail = handledWorkExecutionFuture;
        return workFutureForCaller;
    }

    @Override
    public CompletableFuture<BulkResult> addBulkExecution(CompletableFuture<? extends ElasticsearchWork<BulkResult>> workFuture) {
        SequenceContext currentSequenceAttributes = this.currentlyBuildingSequenceContext;
        CompletionStage bulkWorkResultFuture = ((CompletableFuture)this.currentlyBuildingSequenceTail.thenCombine(workFuture, (ignored, work) -> work)).thenCompose(work -> work.execute(currentSequenceAttributes.executionContext));
        this.currentlyBuildingSequenceTail = ((CompletableFuture)bulkWorkResultFuture).exceptionally(Futures.handler(throwable -> {
            throw new PreviousWorkException((Throwable)throwable);
        }));
        return bulkWorkResultFuture;
    }

    @Override
    public ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep addBulkResultExtraction(CompletableFuture<BulkResult> bulkResultFuture) {
        SequenceContext currentSequenceAttributes = this.currentlyBuildingSequenceContext;
        CompletionStage extractorFuture = bulkResultFuture.thenApply(bulkResult -> bulkResult.withContext(currentSequenceAttributes.executionContext));
        this.bulkResultExtractionStep.init((CompletableFuture<BulkResultItemExtractor>)extractorFuture);
        return this.bulkResultExtractionStep;
    }

    @Override
    public CompletableFuture<Void> build() {
        SequenceContext sequenceContext = this.currentlyBuildingSequenceContext;
        return Futures.whenCompleteExecute(this.currentlyBuildingSequenceTail, () -> sequenceContext.executionContext.executePendingRefreshes().whenComplete(Futures.copyHandler((CompletableFuture)sequenceContext.refreshFuture))).exceptionally(Futures.handler(t -> {
            sequenceContext.notifySequenceFailed((Throwable)t);
            return null;
        }));
    }

    <T> CompletableFuture<T> addPostExecutionHandlers(ElasticsearchWork<T> work, CompletableFuture<T> workExecutionFuture, CompletableFuture<T> workFutureForCaller, SequenceContext sequenceContext) {
        ((CompletableFuture)workExecutionFuture.thenCombine((CompletionStage)sequenceContext.refreshFuture, (workResult, refreshResult) -> workResult)).whenComplete(Futures.copyHandler(workFutureForCaller));
        return workExecutionFuture.exceptionally(Futures.handler(throwable -> {
            sequenceContext.notifyWorkFailed(work, (Throwable)throwable, workFutureForCaller);
            throw new PreviousWorkException((Throwable)throwable);
        }));
    }

    private static final class SequenceContext {
        private final ElasticsearchRefreshableWorkExecutionContext executionContext;
        private final CompletableFuture<Void> refreshFuture;

        SequenceContext(ElasticsearchRefreshableWorkExecutionContext executionContext) {
            this.executionContext = executionContext;
            this.refreshFuture = new CompletableFuture();
        }

        <R> void notifyWorkSkipped(ElasticsearchWork<R> work, Throwable throwable, CompletableFuture<R> workFutureForCaller) {
            Throwable skippingCause = throwable instanceof PreviousWorkException ? throwable.getCause() : throwable;
            workFutureForCaller.completeExceptionally((Throwable)log.elasticsearchSkippedBecauseOfPreviousWork(skippingCause));
        }

        <R> void notifyWorkFailedBecauseBulkFailed(BulkableElasticsearchWork<R> work, Throwable throwable, CompletableFuture<R> workFutureForCaller) {
            this.notifyWorkFailed(work, (Throwable)log.elasticsearchFailedBecauseOfBulkFailure(throwable), workFutureForCaller);
        }

        <R> void notifyWorkFailed(ElasticsearchWork<R> work, Throwable throwable, CompletableFuture<R> workFutureForCaller) {
            workFutureForCaller.completeExceptionally(throwable);
        }

        void notifySequenceFailed(Throwable throwable) {
            if (!(throwable instanceof PreviousWorkException)) {
                throw Throwables.toRuntimeException((Throwable)throwable);
            }
        }
    }

    private static final class PreviousWorkException
    extends RuntimeException {
        public PreviousWorkException(Throwable cause) {
            super(cause);
        }
    }

    private final class BulkResultExtractionStepImpl
    implements ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep {
        private CompletableFuture<BulkResultItemExtractor> extractorFuture;

        private BulkResultExtractionStepImpl() {
        }

        void init(CompletableFuture<BulkResultItemExtractor> extractorFuture) {
            this.extractorFuture = extractorFuture;
        }

        @Override
        public <T> CompletableFuture<T> add(BulkableElasticsearchWork<T> bulkedWork, int index) {
            SequenceContext sequenceContext = ElasticsearchDefaultWorkSequenceBuilder.this.currentlyBuildingSequenceContext;
            CompletableFuture workFutureForCaller = new CompletableFuture();
            CompletionStage handledWorkExecutionFuture = ((CompletableFuture)this.extractorFuture.whenComplete(Futures.handler((result, throwable) -> {
                if (throwable == null) {
                    return;
                }
                if (throwable instanceof PreviousWorkException) {
                    sequenceContext.notifyWorkSkipped(bulkedWork, (Throwable)throwable, workFutureForCaller);
                } else {
                    sequenceContext.notifyWorkFailedBecauseBulkFailed(bulkedWork, (Throwable)throwable, workFutureForCaller);
                }
            }))).thenCompose(extractor -> {
                CompletableFuture workExecutionFuture = Futures.create(() -> extractor.extract(bulkedWork, index));
                return ElasticsearchDefaultWorkSequenceBuilder.this.addPostExecutionHandlers(bulkedWork, workExecutionFuture, workFutureForCaller, sequenceContext);
            });
            ElasticsearchDefaultWorkSequenceBuilder.this.currentlyBuildingSequenceTail = CompletableFuture.allOf(new CompletableFuture[]{ElasticsearchDefaultWorkSequenceBuilder.this.currentlyBuildingSequenceTail, handledWorkExecutionFuture});
            return workFutureForCaller;
        }
    }
}

