/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClient;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchImmutableWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchRefreshableWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.RefreshWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.engine.reporting.FailureContext;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchDefaultWorkExecutionContext
implements ElasticsearchRefreshableWorkExecutionContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchClient client;
    private final GsonProvider gsonProvider;
    private final FailureHandler failureHandler;
    private final ElasticsearchWorkBuilderFactory workFactory;
    private final Set<URLEncodedString> indexesToRefresh = new HashSet<URLEncodedString>();
    private final ElasticsearchWorkExecutionContext refreshExecutionContext;

    public ElasticsearchDefaultWorkExecutionContext(ElasticsearchClient client, GsonProvider gsonProvider, ElasticsearchWorkBuilderFactory workFactory, FailureHandler failureHandler) {
        this.client = client;
        this.gsonProvider = gsonProvider;
        this.failureHandler = failureHandler;
        this.workFactory = workFactory;
        this.refreshExecutionContext = new ElasticsearchImmutableWorkExecutionContext(client, gsonProvider);
    }

    @Override
    public ElasticsearchClient getClient() {
        return this.client;
    }

    @Override
    public GsonProvider getGsonProvider() {
        return this.gsonProvider;
    }

    @Override
    public void registerIndexToRefresh(URLEncodedString indexName) {
        this.indexesToRefresh.add(indexName);
    }

    @Override
    public CompletableFuture<Void> executePendingRefreshes() {
        CompletionStage<Object> future = CompletableFuture.completedFuture(null);
        if (!this.indexesToRefresh.isEmpty()) {
            future = ((CompletableFuture)future.thenCompose(ignored -> this.refreshIndexes())).thenRun(this.indexesToRefresh::clear);
        }
        return future;
    }

    private CompletableFuture<?> refreshIndexes() {
        if (log.isTraceEnabled()) {
            log.tracef("Refreshing index(es) %s", this.indexesToRefresh);
        }
        RefreshWorkBuilder builder = this.workFactory.refresh();
        for (URLEncodedString index : this.indexesToRefresh) {
            builder.index(index);
        }
        Object work = builder.build();
        return work.execute(this.refreshExecutionContext).handle(Futures.handler((result, throwable) -> {
            if (throwable != null) {
                FailureContext.Builder contextBuilder = FailureContext.builder();
                contextBuilder.throwable(throwable);
                contextBuilder.failingOperation(work);
                this.failureHandler.handle(contextBuilder.build());
            }
            return null;
        }));
    }
}

