/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.AbstractElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestratorImplementor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkProcessor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkSet;
import org.hibernate.search.engine.backend.orchestration.spi.BatchingExecutor;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.reporting.FailureHandler;

class ElasticsearchBatchingWorkOrchestrator
extends AbstractElasticsearchWorkOrchestrator
implements ElasticsearchWorkOrchestratorImplementor {
    private final ThreadPoolProvider threadPoolProvider;
    private final BatchingExecutor<ElasticsearchWorkSet, ElasticsearchWorkProcessor> executor;

    ElasticsearchBatchingWorkOrchestrator(String name, ElasticsearchWorkProcessor processor, ThreadPoolProvider threadPoolProvider, int maxWorksetsPerBatch, boolean fair, FailureHandler failureHandler) {
        super(name);
        this.threadPoolProvider = threadPoolProvider;
        this.executor = new BatchingExecutor(name, (BatchingExecutor.WorkProcessor)processor, maxWorksetsPerBatch, fair, failureHandler);
    }

    public ElasticsearchWorkOrchestratorImplementor createChild(String name) {
        return new ElasticsearchChildBatchingWorkOrchestrator(name);
    }

    protected void doStart() {
        this.executor.start(this.threadPoolProvider);
    }

    protected void doSubmit(ElasticsearchWorkSet workSet) throws InterruptedException {
        this.executor.submit((BatchingExecutor.WorkSet)workSet);
    }

    protected CompletableFuture<?> getCompletion() {
        return this.executor.getCompletion();
    }

    protected void doStop() {
        this.executor.stop();
    }

    private class ElasticsearchChildBatchingWorkOrchestrator
    extends AbstractElasticsearchWorkOrchestrator
    implements ElasticsearchWorkOrchestratorImplementor {
        protected ElasticsearchChildBatchingWorkOrchestrator(String name) {
            super(name);
        }

        protected void doStart() {
        }

        protected void doSubmit(ElasticsearchWorkSet workSet) {
            ElasticsearchBatchingWorkOrchestrator.this.submit(workSet);
        }

        protected CompletableFuture<?> getCompletion() {
            return ElasticsearchBatchingWorkOrchestrator.this.getCompletion();
        }

        protected void doStop() {
        }
    }
}

