/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.multitenancy.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.regex.Pattern;
import org.hibernate.search.backend.elasticsearch.document.impl.DocumentMetadataContributor;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.IndexSchemaRootContributor;
import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractionHelper;
import org.hibernate.search.backend.elasticsearch.util.impl.ElasticsearchFields;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class DiscriminatorMultiTenancyStrategy
implements MultiTenancyStrategy {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String ID_FIELD_NAME = ElasticsearchFields.internalFieldName("tenant_doc_id");
    private static final String TENANT_ID_FIELD_NAME = ElasticsearchFields.internalFieldName("tenant_id");
    private static final Pattern UNDERSCORE_PATTERN = Pattern.compile("_");
    private static final String ESCAPED_UNDERSCORE = "__";
    private final DiscriminatorMultiTenancyDocumentMetadataContributor documentMetadataContributor = new DiscriminatorMultiTenancyDocumentMetadataContributor();
    private final DiscriminatorMultiTenancyIndexSchemaRootContributor schemaRootContributor = new DiscriminatorMultiTenancyIndexSchemaRootContributor();
    private final DiscriminatorMultiTenancyIdProjectionExtractionHelper idProjectionExtractionHelper = new DiscriminatorMultiTenancyIdProjectionExtractionHelper();

    @Override
    public boolean isMultiTenancySupported() {
        return true;
    }

    @Override
    public Optional<IndexSchemaRootContributor> getIndexSchemaRootContributor() {
        return Optional.of(this.schemaRootContributor);
    }

    @Override
    public String toElasticsearchId(String tenantId, String id) {
        return UNDERSCORE_PATTERN.matcher(tenantId).replaceAll(ESCAPED_UNDERSCORE) + "_" + UNDERSCORE_PATTERN.matcher(id).replaceAll(ESCAPED_UNDERSCORE);
    }

    @Override
    public Optional<DocumentMetadataContributor> getDocumentMetadataContributor() {
        return Optional.of(this.documentMetadataContributor);
    }

    @Override
    public JsonObject decorateJsonQuery(JsonObject originalJsonQuery, String tenantId) {
        JsonObject jsonQuery = new JsonObject();
        JsonObjectAccessor boolQuery = JsonAccessor.root().property("bool").asObject();
        boolQuery.property("filter").asObject().property("term").asObject().property(TENANT_ID_FIELD_NAME).asString().set(jsonQuery, tenantId);
        if (originalJsonQuery != null) {
            boolQuery.property("must").set(jsonQuery, originalJsonQuery);
        }
        return jsonQuery;
    }

    public DiscriminatorMultiTenancyIdProjectionExtractionHelper getIdProjectionExtractionHelper() {
        return this.idProjectionExtractionHelper;
    }

    @Override
    public void checkTenantId(String tenantId, EventContext backendContext) {
        if (tenantId == null) {
            throw log.multiTenancyEnabledButNoTenantIdProvided(backendContext);
        }
    }

    private static final class DiscriminatorMultiTenancyIdProjectionExtractionHelper
    implements ProjectionExtractionHelper<String> {
        private static final JsonArrayAccessor DOCVALUE_FIELDS_ACCESSOR = JsonAccessor.root().property("docvalue_fields").asArray();
        private static final JsonAccessor<String> HIT_ID_ACCESSOR = JsonAccessor.root().property("fields").asObject().property(DiscriminatorMultiTenancyStrategy.access$300()).asArray().element(0).asString();
        private static final JsonElement ID_FIELD_NAME_JSON = new JsonPrimitive(DiscriminatorMultiTenancyStrategy.access$300());

        private DiscriminatorMultiTenancyIdProjectionExtractionHelper() {
        }

        @Override
        public void request(JsonObject requestBody) {
            DOCVALUE_FIELDS_ACCESSOR.addElementIfAbsent(requestBody, ID_FIELD_NAME_JSON);
        }

        @Override
        public String extract(JsonObject hit) {
            return HIT_ID_ACCESSOR.get(hit).orElseThrow(log::elasticsearchResponseMissingData);
        }
    }

    private static class DiscriminatorMultiTenancyDocumentMetadataContributor
    implements DocumentMetadataContributor {
        private static final JsonAccessor<String> TENANT_ID_ACCESSOR = JsonAccessor.root().property(DiscriminatorMultiTenancyStrategy.access$400()).asString();
        private static final JsonAccessor<String> ID_ACCESSOR = JsonAccessor.root().property(DiscriminatorMultiTenancyStrategy.access$300()).asString();

        private DiscriminatorMultiTenancyDocumentMetadataContributor() {
        }

        @Override
        public void contribute(JsonObject document, String tenantId, String id) {
            TENANT_ID_ACCESSOR.set(document, tenantId);
            ID_ACCESSOR.set(document, id);
        }
    }

    private static class DiscriminatorMultiTenancyIndexSchemaRootContributor
    implements IndexSchemaRootContributor {
        private DiscriminatorMultiTenancyIndexSchemaRootContributor() {
        }

        @Override
        public void contribute(RootTypeMapping rootTypeMapping) {
            PropertyMapping idPropertyMapping = new PropertyMapping();
            idPropertyMapping.setType("keyword");
            idPropertyMapping.setIndex(false);
            idPropertyMapping.setStore(false);
            idPropertyMapping.setDocValues(true);
            rootTypeMapping.addProperty(ID_FIELD_NAME, idPropertyMapping);
            PropertyMapping tenantIdPropertyMapping = new PropertyMapping();
            tenantIdPropertyMapping.setType("keyword");
            tenantIdPropertyMapping.setIndex(true);
            tenantIdPropertyMapping.setStore(false);
            tenantIdPropertyMapping.setDocValues(true);
            rootTypeMapping.addProperty(TENANT_ID_FIELD_NAME, tenantIdPropertyMapping);
        }
    }
}

