/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.mapping.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.backend.elasticsearch.document.impl.DocumentMetadataContributor;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.IndexSchemaRootContributor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.mapping.impl.TypeNameMapping;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractionHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class IndexNameTypeNameMapping
implements TypeNameMapping {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final TypeNameFromIndexNameExtractionHelper mappedTypeNameExtractionHelper = new TypeNameFromIndexNameExtractionHelper();

    @Override
    public Optional<IndexSchemaRootContributor> getIndexSchemaRootContributor() {
        return Optional.empty();
    }

    @Override
    public Optional<DocumentMetadataContributor> getDocumentMetadataContributor(String mappedTypeName) {
        return Optional.empty();
    }

    @Override
    public void register(String elasticsearchIndexName, String mappedTypeName) {
        this.mappedTypeNameExtractionHelper.mappedTypeNamesByElasticsearchIndexNames.put(elasticsearchIndexName, mappedTypeName);
    }

    @Override
    public ProjectionExtractionHelper<String> getTypeNameExtractionHelper() {
        return this.mappedTypeNameExtractionHelper;
    }

    private static final class TypeNameFromIndexNameExtractionHelper
    implements ProjectionExtractionHelper<String> {
        private static final JsonAccessor<String> HIT_INDEX_NAME_ACCESSOR = JsonAccessor.root().property("_index").asString();
        private final Map<String, String> mappedTypeNamesByElasticsearchIndexNames = new ConcurrentHashMap<String, String>();

        private TypeNameFromIndexNameExtractionHelper() {
        }

        @Override
        public void request(JsonObject requestBody) {
        }

        @Override
        public String extract(JsonObject hit) {
            String elasticsearchIndexName = HIT_INDEX_NAME_ACCESSOR.get(hit).orElseThrow(log::elasticsearchResponseMissingData);
            String mappedTypeName = this.mappedTypeNamesByElasticsearchIndexNames.get(elasticsearchIndexName);
            if (mappedTypeName == null) {
                throw log.elasticsearchResponseUnknownIndexName(elasticsearchIndexName);
            }
            return mappedTypeName;
        }
    }
}

