/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.mapping.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.document.impl.DocumentMetadataContributor;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.IndexSchemaRootContributor;
import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.mapping.impl.TypeNameMapping;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractionHelper;
import org.hibernate.search.backend.elasticsearch.util.impl.ElasticsearchFields;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class DiscriminatorTypeNameMapping
implements TypeNameMapping {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String MAPPED_TYPE_FIELD_NAME = ElasticsearchFields.internalFieldName("entity_type");
    private final TypeNameDiscriminatorSchemaRootContributor schemaRootContributor = new TypeNameDiscriminatorSchemaRootContributor();
    private final TypeNameFromDiscriminatorExtractionHelper typeNameExtractionHelper = new TypeNameFromDiscriminatorExtractionHelper();

    @Override
    public Optional<IndexSchemaRootContributor> getIndexSchemaRootContributor() {
        return Optional.of(this.schemaRootContributor);
    }

    @Override
    public Optional<DocumentMetadataContributor> getDocumentMetadataContributor(String mappedTypeName) {
        return Optional.of(new TypeNameDiscriminatorContributor(mappedTypeName));
    }

    @Override
    public void register(String elasticsearchIndexName, String mappedTypeName) {
    }

    @Override
    public ProjectionExtractionHelper<String> getTypeNameExtractionHelper() {
        return this.typeNameExtractionHelper;
    }

    private static final class TypeNameFromDiscriminatorExtractionHelper
    implements ProjectionExtractionHelper<String> {
        private static final JsonArrayAccessor DOCVALUE_FIELDS_ACCESSOR = JsonAccessor.root().property("docvalue_fields").asArray();
        private static final JsonAccessor<String> HIT_MAPPED_TYPE_NAME_ACCESSOR = JsonAccessor.root().property("fields").asObject().property(DiscriminatorTypeNameMapping.access$300()).asArray().element(0).asString();
        private static final JsonElement MAPPED_TYPE_FIELD_NAME_JSON = new JsonPrimitive(DiscriminatorTypeNameMapping.access$300());

        private TypeNameFromDiscriminatorExtractionHelper() {
        }

        @Override
        public void request(JsonObject requestBody) {
            DOCVALUE_FIELDS_ACCESSOR.addElementIfAbsent(requestBody, MAPPED_TYPE_FIELD_NAME_JSON);
        }

        @Override
        public String extract(JsonObject hit) {
            return HIT_MAPPED_TYPE_NAME_ACCESSOR.get(hit).orElseThrow(() -> log.missingTypeFieldInDocument(MAPPED_TYPE_FIELD_NAME));
        }
    }

    private static final class TypeNameDiscriminatorContributor
    implements DocumentMetadataContributor {
        private static final JsonAccessor<String> DOCUMENT_MAPPED_TYPE_FIELD_ACCESSOR = JsonAccessor.root().property(DiscriminatorTypeNameMapping.access$300()).asString();
        private final String mappedTypeName;

        private TypeNameDiscriminatorContributor(String mappedTypeName) {
            this.mappedTypeName = mappedTypeName;
        }

        @Override
        public void contribute(JsonObject document, String tenantId, String id) {
            DOCUMENT_MAPPED_TYPE_FIELD_ACCESSOR.set(document, this.mappedTypeName);
        }
    }

    private static final class TypeNameDiscriminatorSchemaRootContributor
    implements IndexSchemaRootContributor {
        private TypeNameDiscriminatorSchemaRootContributor() {
        }

        @Override
        public void contribute(RootTypeMapping rootTypeMapping) {
            PropertyMapping mappedTypePropertyMapping = new PropertyMapping();
            mappedTypePropertyMapping.setType("keyword");
            mappedTypePropertyMapping.setIndex(false);
            mappedTypePropertyMapping.setStore(false);
            mappedTypePropertyMapping.setDocValues(true);
            rootTypeMapping.addProperty(MAPPED_TYPE_FIELD_NAME, mappedTypePropertyMapping);
        }
    }
}

